<?php
/**
 * Footer Template  File
 *
 * @package MANZIL
 * @author  YogsThemes
 * @version 1.0
 */

$options = manzil_WSH()->option();

$bg_img_2    = $options->get( 'footer_bg_img_2' );
$bg_img_2   = manzil_set( $bg_img_2, 'url', MANZIL_URI . 'assets/images/background/5.jpg' );

$allowed_html = wp_kses_allowed_html( 'post' );
?>
	
<!-- Main Footer / Style Two -->
<footer class="main-footer style-two" style="background-image:url(<?php echo esc_url($bg_img_2);?>)">
    <?php if ( is_active_sidebar( 'footer-sidebar' ) ) { ?>
    <div class="auto-container">
        <!--Widgets Section-->
        <div class="widgets-section">
            <div class="row clearfix">
                <?php dynamic_sidebar( 'footer-sidebar' ); ?>
            </div>
        </div>
    </div>
    <?php } ?>
    <!-- Footer Bottom -->
    <div class="footer-bottom style-two">
        <div class="auto-container">
            <div class="row clearfix">
                <!-- Column -->
                <div class="column col-lg-6 col-md-12 col-sm-12">
                    <div class="copyright"><?php echo wp_kses( $options->get( 'copyright_text2', '&copy; All rights reserved by <a href="#">Yogsthemes</a>' ), $allowed_html ); ?></div>
                </div>
                <?php
					$icons = $options->get( 'footer_v2_social_share' );
					if ( ! empty( $icons ) ) :
				?>
                <!-- Column -->
                <div class="column col-lg-6 col-md-12 col-sm-12">
                    <!-- Social Box -->
                    <ul class="social-box">
                    <?php
						foreach ( $icons as $h_icon ) :
						$header_social_icons = json_decode( urldecode( manzil_set( $h_icon, 'data' ) ) );
						if ( manzil_set( $header_social_icons, 'enable' ) == '' ) {
							continue;
						}
						$icon_class = explode( '-', manzil_set( $header_social_icons, 'icon' ) );
						?>
						<li><a href="<?php echo esc_url(manzil_set( $header_social_icons, 'url' )); ?>" style="background-color:<?php echo esc_attr(manzil_set( $header_social_icons, 'background' )); ?>; color: <?php echo esc_attr(manzil_set( $header_social_icons, 'color' )); ?>" class="fa <?php echo esc_attr( manzil_set( $header_social_icons, 'icon' ) ); ?>"></a></li>
					<?php endforeach; ?>
                    </ul>
                </div>
                <?php endif;?>
            </div>
        </div>
    </div>
    
</footer>
<!-- End Main Footer -->