<?php
/**
 * Blog Post Main File.
 *
 * @package MANZIL
 * @author  YogsThemes
 * @version 1.0
 */

get_header();
$data    = \MANZIL\Includes\Classes\Common::instance()->data( 'single' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-xs-12 col-sm-12 col-md-12' : 'col-lg-8 col-md-12 col-sm-12';
$options = manzil_WSH()->option();

if ( class_exists( '\Elementor\Plugin' ) && $data->get( 'tpl-type' ) == 'e') {
	
	while(have_posts()) {
	   the_post();
	   the_content();
    }

} else {
?>

<?php if ( class_exists( '\Elementor\Plugin' )): ?>
	<?php do_action( 'manzil_banner', $data ); ?>
<?php else: ?>

<!-- Page Title -->
<section class="page-title" style="background-image: url('<?php echo esc_url( $data->get( 'banner' ) ); ?>')">
    <div class="auto-container">
        <h1><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h1>
        <ul class="page-breadcrumb">
            <?php echo manzil_the_breadcrumb(); ?>
        </ul>
    </div>
</section>
<!-- End Page Title -->
<?php endif; ?>

<!-- Sidebar Page Container -->
<div class="sidebar-page-container">
    <div class="auto-container">
        <div class="row clearfix">
        	<?php
				if ( $data->get( 'layout' ) == 'left' ) {
					do_action( 'manzil_sidebar', $data );
				}
			?>
            <div class="content-side <?php echo esc_attr( $class ); ?>">
            	<div class="thm-unit-test">
					<?php while ( have_posts() ) : the_post(); ?>
                    
                    <div <?php post_class('blog-post'); ?>>    
                        
                        <div class="news-detail">
                            
                            <div class="inner-box">
                                <?php if( has_post_thumbnail() ):?>
                                <div class="image">
                                    <?php the_post_thumbnail('manzil_1170x400'); ?>
                                    <div class="post-date">
                                        <?php echo get_the_date('d'); ?>
                                        <span><?php echo get_the_date('M'); ?></span>
                                    </div>
                                </div>
                                <?php endif;?>
                                <div class="lower-content <?php if(! has_post_thumbnail() ) echo 'p-t0';?>">
                                    <ul class="post-meta m-t0 m-b15">
                                        <li><span class="icon fa fa-comments"></span><?php comments_number( wp_kses(__('0 Comments' , 'manzil'), true), wp_kses(__('1 Comment' , 'manzil'), true), wp_kses(__('% Comments' , 'manzil'), true)); ?></li>
                                        <li><span class="icon fa fa-user"></span><?php esc_html_e('By', 'manzil'); ?> <?php the_author(); ?></li>
                                    </ul>
                                    <div class="text">
                                        <?php the_content(); ?>
                                        <div class="clearfix"></div>
                                        <?php wp_link_pages(array('before'=>'<div class="paginate-links m-b30">'.esc_html__('Pages: ', 'manzil'), 'after' => '</div>', 'link_before'=>'<span>', 'link_after'=>'</span>')); ?>
                                    </div>
                                    <!-- Post Share Options-->
                                    <div class="post-share-options <?php if( $options->get( 'single_post_tag' ) ) echo 'p-a22';?>">
                                        <div class="post-share-inner clearfix">
                                            <?php if( $options->get( 'single_post_tag' ) ):?>
                                            <div class="pull-left tags">
                                                <span class="fa fa-tags"></span>
                                                <?php the_tags( '',', ', '' ); ?>
                                            </div>
                                            <?php endif; ?>
                                            
                                            <?php if(function_exists('bunch_share_us_two')):?>
                                                <?php echo wp_kses(bunch_share_us_two(get_the_id(),$post->post_name ), true);?>
                                            <?php endif;?>
                                        </div>
                                    </div>
                                    <?php if((get_previous_post()) || (get_next_post())): ?>
                                    <!-- More Posts -->
                                    <div class="more-posts  <?php if(! $options->get( 'single_post_tag' ) ) echo 'm-t40';?>">
                                        <div class="clearfix">
                                            <?php global $post; $prev_post = get_previous_post();
                                                if (!empty($prev_post)):
                                            ?>
                                            <div class="prev pull-left"><a href="<?php echo esc_url(get_permalink($prev_post->ID)); ?>"><span class="fa fa-angle-double-left"></span>&nbsp; <?php esc_html_e('Previous Post', 'manzil');?></a></div>
                                            <?php endif;?>
                                            <?php global $post; $next_post = get_next_post();
                                                if (!empty($next_post)): 
                                            ?>
                                            <div class="next pull-right"><a href="<?php echo esc_url(get_permalink($next_post->ID)); ?>"><?php esc_html_e('Newer Post', 'manzil');?> &nbsp;<span class="fa fa-angle-double-right"></span></a></div>
                                            <?php endif;?>
                                        </div>
                                    </div>
                                    <?php endif;?>
                                </div>
                            </div>
                            
                            <!-- comments Section -->
                            <?php comments_template(); ?>
                        
                        </div>
                        <?php endwhile; ?>
            		</div>
                </div>
        	
            </div>
			<?php
				if ( $data->get( 'layout' ) == 'right' ) {
					do_action( 'manzil_sidebar', $data );
				}
			?>
        </div>
    </div>
</div> 
<!--End blog area-->

<?php
}
get_footer();
