<script type="text/template" id="happyforms-customize-email_integration-template">
	<?php include( happyforms_get_core_folder() . '/templates/customize-form-part-header.php' ); ?>

	<?php do_action( 'happyforms_part_customize_email_integration_before_options' ); ?>

	<p class="label-field-group">
		<label for="<%= instance.id %>_title"><?php _e( 'Label', 'happyforms' ); ?></label>
		<div class="label-group">
			<input type="text" id="<%= instance.id %>_title" class="widefat title" value="<%- instance.label %>" data-bind="label" />
			<div class="happyforms-buttongroup">
				<label for="<%= instance.id %>-label_placement-show">
					<input type="radio" id="<%= instance.id %>-label_placement-show" value="show" name="<%= instance.id %>-label_placement" data-bind="label_placement" <%= ( instance.label_placement == 'show' ) ? 'checked' : '' %> />
					<span><?php _e( 'Show', 'happyforms' ); ?></span>
				</label>
				<label for="<%= instance.id %>-label_placement-hidden">
					<input type="radio" id="<%= instance.id %>-label_placement-hidden" value="hidden" name="<%= instance.id %>-label_placement" data-bind="label_placement" <%= ( instance.label_placement == 'hidden' ) ? 'checked' : '' %> />
					<span><?php _e( 'Hide', 'happyforms' ); ?></span>
				</label>
 			</div>
		</div>
	</p>

	<p>
		<label for="<%= instance.id %>_description"><?php _e( 'Hint', 'happyforms' ); ?></label>
		<textarea id="<%= instance.id %>_description" data-bind="description"><%= instance.description %></textarea>
	</p>

	<div class="happyforms-part-control-wrap">
		<div class="wp-editor-container">
			<textarea id="<%= instance.id %>_email_integration_text" rows="5" name="email_integration_text" data-bind="email_integration_text" class="widefat"><%= instance.email_integration_text %></textarea>
		</div>
	</div>

	<?php do_action( 'happyforms_part_customize_email_integration_after_options' ); ?>

	<?php do_action( 'happyforms_part_customize_email_integration_before_advanced_options' ); ?>

	<p>
		<label>
			<input type="checkbox" class="checkbox" value="1" <% if ( instance.required ) { %>checked="checked"<% } %> data-bind="required" /> <?php _e( 'Require an answer', 'happyforms' ); ?>
		</label>
	</p>

	<?php happyforms_customize_part_width_control(); ?>

	<?php do_action( 'happyforms_part_customize_email_integration_after_advanced_options' ); ?>

	<p>
		<label for="<%= instance.id %>_css_class"><?php _e( 'Additional CSS class(es)', 'happyforms' ); ?></label>
		<input type="text" id="<%= instance.id %>_css_class" class="widefat title" value="<%- instance.css_class %>" data-bind="css_class" />
	</p>

	<div class="happyforms-part-logic-wrap">
		<div class="happyforms-logic-view">
			<?php happyforms_customize_part_logic(); ?>
		</div>
	</div>

	<div class="happyforms-widget-actions">
		<a href="#" class="happyforms-form-part-remove"><?php _e( 'Delete', 'happyforms' ); ?></a>
		<a href="#" class="happyforms-form-part-logic"><?php _e( 'Logic', 'happyforms' ); ?></a>
	</div>
</script>
