<?php
namespace BdevsElement\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Image_Size;
Use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Utils;

defined( 'ABSPATH' ) || die();

class FAQ extends BDevs_El_Widget {

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Element widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'faq';
    }

    /**
     * Get widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'FAQ', 'bdevselement' );
    }

	public function get_custom_help_url() {
		return 'http://elementor.bdevs.net//widgets/contact-7-form/';
	}

    /**
     * Get widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-edit';
    }

    public function get_keywords() {
        return [ 'services', 'tab' ];
    }

	protected function register_content_controls() {

        $this->start_controls_section(
            '_section_design_title',
            [
                'label' => __( 'Design Style', 'bdevselement' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'design_style',
            [
                'label' => __( 'Design Style', 'bdevselement' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'bdevselement' ),
                    'style_2' => __( 'Style 2', 'bdevselement' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            '_section_title',
            [
                'label' => __( 'Title ', 'bdevselement' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'bdevselement' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Heading Title',
                'placeholder' => __( 'Heading Text', 'bdevselement' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'sub_title',
            [
                'label' => __( 'Sub Title', 'bdevselement' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Heading Sub Title',
                'placeholder' => __( 'Heading Sub Text', 'bdevselement' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'desccription',
            [
                'label' => __( 'Desccription', 'bdevselement' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Heading Desccription Text', 'bdevselement' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => __( 'Title HTML Tag', 'bdevselement' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1'  => [
                        'title' => __( 'H1', 'bdevselement' ),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2'  => [
                        'title' => __( 'H2', 'bdevselement' ),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3'  => [
                        'title' => __( 'H3', 'bdevselement' ),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4'  => [
                        'title' => __( 'H4', 'bdevselement' ),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5'  => [
                        'title' => __( 'H5', 'bdevselement' ),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6'  => [
                        'title' => __( 'H6', 'bdevselement' ),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h2',
                'toggle' => false,
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __( 'Alignment', 'bdevselement' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'bdevselement' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'bdevselement' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'bdevselement' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_image',
            [
                'label' => __( 'Image', 'bdevselement' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'tab_big_image',
            [
                'label' => __( 'BG Image', 'bdevselement' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );        

        $this->add_control(
            'tab_small_image',
            [
                'label' => __( 'Faq Image', 'bdevselement' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => ['style_1']
                ],
            ]
        );        

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_slides',
            [
                'label' => __( 'Faq List', 'bdevselement' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();
  
        $repeater->add_control(
            'tab_title',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => __( 'Tab Title', 'bdevselement' ),
                'default' => __( 'Tab Title', 'bdevselement' ),
                'placeholder' => __( 'Type title here', 'bdevselement' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );      

        $repeater->add_control(
            'tab_content_info',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'show_label' => false,
                'default' => __( 'Content Here', 'bdevselement' ),
                'placeholder' => __( 'Type subtitle here', 'bdevselement' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        // REPEATER
        $this->add_control(
            'slides',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '<# print(tab_title || "Carousel Item"); #>',
                'default' => [
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                ]
            ]
        );

        $this->end_controls_section();

    }




    // register_style_controls

    protected function register_style_controls() {

        $this->start_controls_section(
            '_section_style_contents',
            [
                'label' => __( 'Title / Content', 'bdevselement' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_responsive_control(
                'content_paddings',
                [
                    'label' => __( 'Content Padding', 'bdevselement' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'content_backgrounds',
                    'selector' => '{{WRAPPER}} .bdevs-el-content',
                    'exclude' => [
                        'image'
                    ]
                ]
            );

            // Title
            $this->add_control(
                '_heading_titles',
                [
                    'type' => Controls_Manager::HEADING,
                    'label' => __( 'Title', 'bdevselement' ),
                    'separator' => 'before'
                ]
            );

            $this->add_responsive_control(
                'title_spacings',
                [
                    'label' => __( 'Bottom Spacing', 'bdevselement' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'title_colosr',
                [
                    'label' => __( 'Text Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'titles',
                    'selector' => '{{WRAPPER}} .bdevs-el-title',
                    'scheme' => Typography::TYPOGRAPHY_2,
                ]
            );


            // Subtitle    
            $this->add_control(
                '_heading_subtitles',
                [
                    'type' => Controls_Manager::HEADING,
                    'label' => __( 'Subtitle', 'bdevselement' ),
                    'separator' => 'before'
                ]
            );

            $this->add_responsive_control(
                'subtitle_spacings',
                [
                    'label' => __( 'Bottom Spacing', 'bdevselement' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'subtitles_color',
                [
                    'label' => __( 'Text Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-subtitle' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'subtitles',
                    'selector' => '{{WRAPPER}} .bdevs-el-subtitle',
                    'scheme' => Typography::TYPOGRAPHY_3,
                ]
            );

        $this->end_controls_section();


        // Tab Title Style
        $this->start_controls_section(
            '_section_tab_style',
            [
                'label' => __('Faq Style', 'bdevselement'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'tab_tile_heading',
                [
                    'type' => Controls_Manager::HEADING,
                    'label' => __('Tab Title', 'bdevselement'),
                    'separator' => 'before'
                ]
            );

            $this->add_responsive_control(
                'tab_tile_spacing',
                [
                    'label' => __('Bottom Spacing', 'bdevselement'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-tab-title-content' => 'margin-bottom: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'tab_tile_padding',
                [
                    'label' => __('Padding', 'bdevselement'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-tab-title-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'tab_tile_border-radius',
                [
                    'label' => __('Border Radius', 'bdevselement'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-tab-title-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'tab_tile_color',
                [
                    'label' => __('Text Color', 'bdevselement'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-tab-title' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'tab_tile_bg_color',
                [
                    'label' => __('Bg Color', 'bdevselement'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-tab-title' => 'background: {{VALUE}};',
                    ],
                ]
            );

            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'tab_tile_typography',
                    'label' => __('Typography', 'bdevselement'),
                    'selector' => '{{WRAPPER}} .bdevs-el-tab-title',
                    'scheme' => Typography::TYPOGRAPHY_3,
                ]
            );

            // Tab Description
            $this->add_control(
                'tab_des_heading',
                [
                    'type' => Controls_Manager::HEADING,
                    'label' => __('Tab Description', 'bdevselement'),
                    'separator' => 'before'
                ]
            );

            $this->add_responsive_control(
                'tab_des_spacing',
                [
                    'label' => __('Bottom Spacing', 'bdevselement'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-tab-des-content' => 'margin-bottom: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'tab_des_padding',
                [
                    'label' => __('Padding', 'bdevselement'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-tab-des-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                'tab_des_color',
                [
                    'label' => __('Text Color', 'bdevselement'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .bdevs-el-tab-des' => 'color: {{VALUE}};',
                    ],
                ]
            );

            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'tab_des_typography',
                    'label' => __('Typography', 'bdevselement'),
                    'selector' => '{{WRAPPER}} .bdevs-el-tab-des',
                    'scheme' => Typography::TYPOGRAPHY_3,
                ]
            );
        $this->end_controls_section();



        $this->start_controls_section(
            '_section_fields_style',
            [
                'label' => __( 'Form Fields', 'bdevselement' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_responsive_control(
                'field_width',
                [
                    'label' => __( 'Width', 'bdevselement' ),
                    'type' => Controls_Manager::SLIDER,
                    'default' => [
                        'unit' => '%',
                    ],
                    'tablet_default' => [
                        'unit' => '%',
                    ],
                    'mobile_default' => [
                        'unit' => '%',
                    ],
                    'size_units' => [ '%', 'px' ],
                    'range' => [
                        '%' => [
                            'min' => 1,
                            'max' => 100,
                        ],
                        'px' => [
                            'min' => 1,
                            'max' => 500,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'width: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .bdevs-cf7-form label' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'field_margin',
                [
                    'label' => __( 'Spacing Bottom', 'bdevselement' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'field_padding',
                [
                    'label' => __( 'Padding', 'bdevselement' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'field_border_radius',
                [
                    'label' => __( 'Border Radius', 'bdevselement' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'hr',
                [
                    'type' => Controls_Manager::DIVIDER,
                    'style' => 'thick',
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'field_typography',
                    'label' => __( 'Typography', 'bdevselement' ),
                    'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)',
                    'scheme' => Typography::TYPOGRAPHY_3
                ]
            );

            $this->add_control(
                'field_color',
                [
                    'label' => __( 'Text Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'field_placeholder_color',
                [
                    'label' => __( 'Placeholder Text Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} ::-webkit-input-placeholder' => 'color: {{VALUE}};',
                        '{{WRAPPER}} ::-moz-placeholder' => 'color: {{VALUE}};',
                        '{{WRAPPER}} ::-ms-input-placeholder' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->start_controls_tabs( 'tabs_field_state' );

            $this->start_controls_tab(
                'tab_field_normal',
                [
                    'label' => __( 'Normal', 'bdevselement' ),
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'field_border',
                    'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)',
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'field_box_shadow',
                    'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)',
                ]
            );

            $this->add_control(
                'field_bg_color',
                [
                    'label' => __( 'Background Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'background-color: {{VALUE}}',
                    ],
                ]
            );

            $this->end_controls_tab();

            $this->start_controls_tab(
                'tab_field_focus',
                [
                    'label' => __( 'Focus', 'bdevselement' ),
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'field_focus_border',
                    'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit):focus',
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'field_focus_box_shadow',
                    'exclude' => [
                        'box_shadow_position',
                    ],
                    'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit):focus',
                ]
            );

            $this->add_control(
                'field_focus_bg_color',
                [
                    'label' => __( 'Background Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit):focus' => 'background-color: {{VALUE}}',
                    ],
                ]
            );

            $this->end_controls_tab();
            $this->end_controls_tabs();

		$this->end_controls_section();


        $this->start_controls_section(
            'submit',
            [
                'label' => __( 'Submit Button', 'bdevselement' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_responsive_control(
                'submit_margin',
                [
                    'label' => __( 'Margin', 'bdevselement' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .wpcf7-submit' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'submit_padding',
                [
                    'label' => __( 'Padding', 'bdevselement' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .wpcf7-submit' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'submit_typography',
                    'selector' => '{{WRAPPER}} .wpcf7-submit',
                    'scheme' => Typography::TYPOGRAPHY_4
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'submit_border',
                    'selector' => '{{WRAPPER}} .wpcf7-submit',
                ]
            );

            $this->add_control(
                'submit_border_radius',
                [
                    'label' => __( 'Border Radius', 'bdevselement' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .wpcf7-submit' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'submit_box_shadow',
                    'selector' => '{{WRAPPER}} .wpcf7-submit',
                ]
            );

            $this->add_control(
                'hr4',
                [
                    'type' => Controls_Manager::DIVIDER,
                    'style' => 'thick',
                ]
            );

            $this->start_controls_tabs( 'tabs_button_style' );

            $this->start_controls_tab(
                'tab_button_normal',
                [
                    'label' => __( 'Normal', 'bdevselement' ),
                ]
            );

            $this->add_control(
                'submit_color',
                [
                    'label' => __( 'Text Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .wpcf7-submit' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'submit_bg_color',
                [
                    'label' => __( 'Background Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .wpcf7-submit' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_tab();

            $this->start_controls_tab(
                'tab_button_hover',
                [
                    'label' => __( 'Hover', 'bdevselement' ),
                ]
            );

            $this->add_control(
                'submit_hover_color',
                [
                    'label' => __( 'Text Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .wpcf7-submit:hover, {{WRAPPER}} .wpcf7-submit:focus' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'submit_hover_bg_color',
                [
                    'label' => __( 'Background Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .wpcf7-submit:hover, {{WRAPPER}} .wpcf7-submit:focus' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'submit_hover_border_color',
                [
                    'label' => __( 'Border Color', 'bdevselement' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .wpcf7-submit:hover, {{WRAPPER}} .wpcf7-submit:focus' => 'border-color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_tab();
            $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render() {

        $settings = $this->get_settings_for_display(); 
        $this->add_render_attribute( 'title_2', 'class', 'section-title bdevs-el-title' );
        $title = bdevs_element_kses_basic( $settings['title' ] );      


        if ( empty( $settings['slides'] ) ) {
            return;
        }

        ?>

        <?php if ( $settings['design_style'] === 'style_1' ): 

            // img 
            $tab_big_image = wp_get_attachment_image_url( !empty($settings['tab_big_image']['id']), !empty($settings['tab_big_image_size']) );
            if ( ! $tab_big_image ) {
                $tab_big_image = $settings['tab_big_image']['url'];
            }        

            // img small
            $tab_small_image = wp_get_attachment_image_url( !empty($settings['tab_small_image']['id']), !empty($settings['tab_big_image_size']) );
            if ( ! $tab_small_image ) {
                $tab_small_image = $settings['tab_small_image']['url'];
            }  

        ?>
        <section class="faq1 bdevs-el-content">
            <?php if ( $tab_big_image ) : ?>
            <div class="faq1__thumb1">
                <img src="<?php print esc_url($tab_big_image); ?>" alt="Faq Image">
            </div>
            <?php endif; ?>
            <div class="content_box_120">
                <div class="container">
                    <div class="row">
                        <?php if ( $tab_small_image ) : ?>
                        <div class="col-lg-6">
                            <div class="faq1__thumb2">
                                <img src="<?php print esc_url($tab_small_image); ?>" alt="Faq Image" class="img_100">
                            </div>
                        </div>
                        <?php endif; ?>
                        <div class="col-lg-6">
                            <div class="faq1__wrapper">
                                <div class="title_style1 mb-45">
                                <?php if ( $settings['sub_title'] ) : ?>
                                    <h5 class="sub-title bdevs-el-subtitle"><?php echo bdevs_element_kses_intermediate( $settings['sub_title'] ); ?></h5>
                                <?php endif; ?>
                                <?php printf( '<%1$s %2$s>%3$s</%1$s>',
                                    tag_escape( $settings['title_tag'] ),
                                    $this->get_render_attribute_string( 'title_2' ),
                                    $title
                                ); ?>
                                <?php if ( $settings['desccription'] ) : ?>
                                    <p><?php echo bdevs_element_kses_intermediate( $settings['desccription'] ); ?></p>
                                <?php endif; ?>

                                </div>
                                <!-- accordion -->
                                <div class="accordion_style_01">
                                    <div class="accordion" id="accordionExample">
                                        <?php foreach ( $settings['slides'] as $id => $slide ) :
                                            // active class
                                            $collapsed_tab = ($id == 0) ? '' : 'collapsed-';      
                                            $area_expanded = ($id == 0) ? 'true' : 'false';      
                                            $active_show_tab = ($id == 0) ? 'show-' : '';      
                                        ?> 
                                        <div class="card">
                                            <div class="card-header" id="heading_<?php echo esc_attr($id); ?>">
                                                <h5>
                                                    <a class="<?php echo esc_attr($collapsed_tab); ?> bdevs-el-tab-title-content    bdevs-el-tab-title " href="#" data-toggle="collapse" data-target="#collapse_<?php echo esc_attr($id); ?>" aria-expanded="false" aria-controls="collapse_<?php echo esc_attr($id); ?>">
                                                        <?php echo bdevs_element_kses_basic( $slide['tab_title'] ); ?>
                                                        <i class="far fa-plus"></i>
                                                        <i class="far fa-minus"></i>
                                                    </a>
                                                </h5>
                                            </div>
                                            <div id="collapse_<?php echo esc_attr($id); ?>" class="collapse <?php echo esc_attr($active_show_tab); ?>" aria-labelledby="heading_<?php echo esc_attr($id); ?>"
                                                data-parent="#accordionExample">
                                                <div class="card-body bdevs-el-tab-des-content">
                                                    <p class="bdevs-el-tab-des"><?php echo bdevs_element_kses_basic( $slide['tab_content_info'] ); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                                <!-- accordion -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <?php elseif ( $settings['design_style'] === 'style_2' ): ?>

        <section class="faq2 bdevs-el-content">
            <div class="content_box_120">
                <div class="container">
                    <div class="row mb-40">
                        <div class="col-xl-7 col-lg-7">
                            <div class="title_style1">
                                <?php if ( $settings['sub_title'] ) : ?>
                                    <h5 class="sub-title bdevs-el-subtitle"><?php echo bdevs_element_kses_intermediate( $settings['sub_title'] ); ?></h5>
                                <?php endif; ?>
                                <?php printf( '<%1$s %2$s>%3$s</%1$s>',
                                    tag_escape( $settings['title_tag'] ),
                                    $this->get_render_attribute_string( 'title_2' ),
                                    $title
                                ); ?>
                                <?php if ( $settings['desccription'] ) : ?>
                                    <p><?php echo bdevs_element_kses_intermediate( $settings['desccription'] ); ?></p>
                                <?php endif; ?>

                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <!-- accordion -->
                            <div class="accordion_style_01">
                                <div class="accordion" id="accordionExample">
                                    <div class="row">
                                        <?php foreach ( $settings['slides'] as $id => $slide ) :
                                            // active class
                                            $collapsed_tab = ($id == 0) ? '' : 'collapsed-';      
                                            $area_expanded = ($id == 0) ? 'true' : 'false';      
                                            $active_show_tab = ($id == 0) ? 'show-' : '';      
                                        ?> 
                                        <div class="col-lg-6">
                                            <div class="card">
                                                <div class="card-header" id="heading_<?php echo esc_attr($id); ?>">
                                                    <h5>
                                                        <a class="bdevs-el-tab-title-content bdevs-el-tab-title" href="#" data-toggle="collapse" data-target="#collapse_<?php echo esc_attr($id); ?>"
                                                            aria-expanded="false" aria-controls="collapse_<?php echo esc_attr($id); ?>">
                                                            <?php echo bdevs_element_kses_basic( $slide['tab_title'] ); ?>
                                                            <i class="far fa-plus"></i>
                                                            <i class="far fa-minus"></i>
                                                        </a>
                                                    </h5>
                                                </div>
                                                <div id="collapse_<?php echo esc_attr($id); ?>" class="collapse" aria-labelledby="heading_<?php echo esc_attr($id); ?>"
                                                    data-parent="#accordionExample">
                                                    <div class="card-body bdevs-el-tab-des-content">
                                                        <p class=" bdevs-el-tab-des"><?php echo bdevs_element_kses_basic( $slide['tab_content_info'] ); ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                            <!-- accordion -->
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php endif; ?> 

        <?php

    }
}