<?php

/**
 * Blog Content Template
 *
 * @package    WordPress
 * @subpackage MANZIL
 * @author     YogsThemes
 * @version    1.0
 */

if ( class_exists( 'Manzil_Resizer' ) ) {
	$img_obj = new Manzil_Resizer();
} else {
	$img_obj = array();
}
$allowed_tags = wp_kses_allowed_html('post');
global $post;
?>
<div <?php post_class(); ?>>
    <!-- News Block Four -->
    <div class="news-block-four">
        <div class="inner-box">
            <?php if( has_post_thumbnail() ):?>
            <div class="image">
                <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_post_thumbnail('manzil_1170x400'); ?></a>
                <div class="post-date">
                    <?php echo get_the_date('d'); ?>
                    <span><?php echo get_the_date('M'); ?></span>
                </div>
            </div>
            <?php endif;?>
            <div class="lower-content <?php if(! has_post_thumbnail() ) echo 'p-t0';?>">
                <h4><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?> </a></h4>
                <div class="text"><?php the_excerpt(); ?></div>
                <div class="lower-box clearfix">
                    <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="theme-btn btn-style-four"><span class="txt">Read More</span></a>
                    <ul class="post-meta">
                        <li><span class="icon fa fa-comments"></span><?php comments_number( wp_kses(__('0 Comments' , 'manzil'), true), wp_kses(__('1 Comment' , 'manzil'), true), wp_kses(__('% Comments' , 'manzil'), true)); ?></li>
                        <li><span class="icon fa fa-user"></span><?php esc_html_e('By', 'manzil'); ?> <?php the_author(); ?></li>
                    </ul>
                    <?php if(function_exists('bunch_share_us')):?>
                    <!-- Social Box -->
                    <?php echo wp_kses(bunch_share_us(get_the_id(),$post->post_name ), true);?>
                    <?php endif;?>
                </div>
            </div>
        </div>
    </div>
</div>