<?php

return array(
	'title'      => esc_html__( 'Single Post Settings', 'manzil' ),
	'id'         => 'single_post_setting',
	'desc'       => '',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'      => 'single_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Single Post Source Type', 'manzil' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'manzil' ),
				'e' => esc_html__( 'Elementor', 'manzil' ),
			),
			'default' => 'd',
		),

		array(
			'id'       => 'single_default_st',
			'type'     => 'section',
			'title'    => esc_html__( 'Post Default', 'manzil' ),
			'indent'   => true,
			'required' => [ 'single_source_type', '=', 'd' ],
		),
		array(
			'id'      => 'single_post_date',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Date', 'manzil' ),
			'desc'    => esc_html__( 'Enable to show post publish date on posts detail page', 'manzil' ),
			'default' => false,
		),
		array(
			'id'      => 'single_post_author',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Author', 'manzil' ),
			'desc'    => esc_html__( 'Enable to show author on posts detail page', 'manzil' ),
			'default' => false,
		),

		array(
			'id'      => 'single_post_comments',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Comments', 'manzil' ),
			'desc'    => esc_html__( 'Enable to show number of comments on posts single page', 'manzil' ),
			'default' => false,
		),
		array(
			'id'      => 'single_post_tag',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Tags', 'manzil' ),
			'desc'    => esc_html__( 'Enable to show post tags on posts single page', 'manzil' ),
			'default' => false,
		),
		array(
			'id'      => 'facebook_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Facebook Post Share', 'manzil' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Facebook', 'manzil' ),
			'default' => false,
		),
		array(
			'id'      => 'twitter_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Twitter Post Share', 'manzil' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Twitter', 'manzil' ),
			'default' => false,
		),
		array(
			'id'      => 'linkedin_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Linkedin Post Share', 'manzil' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Linkedin', 'manzil' ),
			'default' => false,
		),
		array(
			'id'      => 'pinterest_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Pinterest Post Share', 'manzil' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Pinterest', 'manzil' ),
			'default' => false,
		),
		array(
			'id'      => 'reddit_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Reddit Post Share', 'manzil' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Reddit', 'manzil' ),
			'default' => false,
		),
		array(
			'id'      => 'tumblr_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Tumblr Post Share', 'manzil' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Tumblr', 'manzil' ),
			'default' => false,
		),
		array(
			'id'      => 'digg_sharing',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Digg Post Share', 'manzil' ),
			'desc'    => esc_html__( 'Enable to show Post Share to Digg', 'manzil' ),
			'default' => false,
		),
		array(
			'id'      => 'single_post_author_box',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Author Box', 'manzil' ),
			'desc'    => esc_html__( 'Enable to show author box on post detail page.', 'manzil' ),
			'default' => false,
		),
		array(
			'id'      => 'single_post_author_links',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Author Social Media', 'manzil' ),
			'desc'    => esc_html__( 'Enable to show author Social Media on posts detail page', 'manzil' ),
			'default' => false,
		),
		array(
			'id'    => 'single_post_author_social_share',
			'type'  => 'social_media',
			'title' => esc_html__( 'Author Social Profiles', 'manzil' ),
			'desc'    => esc_html__( 'show author Social Media on posts detail page', 'manzil' ),
		),
		array(
			'id'       => 'single_section_default_ed',
			'type'     => 'section',
			'indent'   => false,
			'required' => [ 'single_source_type', '=', 'd' ],
		),
	),
);





