<?php
return array(
	'title'      => esc_html__( 'Header Setting', 'manzil' ),
	'id'         => 'headers_setting',
	'desc'       => '',
	'subsection' => false,
	'fields'     => array(
		array(
			'id'      => 'header_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Header Source Type', 'manzil' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'manzil' ),
				'e' => esc_html__( 'Elementor', 'manzil' ),
			),
			'default' => 'd',
		),
		array(
			'id'       => 'header_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'manzil' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
				'posts_per_page'	=> -1
			],
			'required' => [ 'header_source_type', '=', 'e' ],
		),
		array(
			'id'       => 'header_style_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Settings', 'manzil' ),
			'required' => array( 'header_source_type', '=', 'd' ),
		),
		array(
		    'id'       => 'header_style_settings',
		    'type'     => 'image_select',
		    'title'    => esc_html__( 'Choose Header Styles', 'manzil' ),
		    'subtitle' => esc_html__( 'Choose Header Styles', 'manzil' ),
		    'options'  => array(

			    'header_v1'  => array(
				    'alt' => esc_html__( 'Header Style 1', 'manzil' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header1.png',
			    ),
			    'header_v2'  => array(
				    'alt' => esc_html__( 'Header Style 2', 'manzil' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header2.png',
			    ),
				'header_v3'  => array(
				    'alt' => esc_html__( 'Header Style 3', 'manzil' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header3.png',
			    ),
			),
			'required' => array( 'header_source_type', '=', 'd' ),
			'default' => 'header_v2',
	    ),
		array(
			'id'       => 'header_v1_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style One Settings', 'manzil' ),
			'required' => array( 'header_style_settings', '=', 'header_v1' ),
		),
		array(
		    'id'       => 'welcome_text',
		    'type'     => 'textarea',
		    'title'    => esc_html__( 'Welcome Text', 'manzil' ),
		    'desc'     => esc_html__( 'Enter The Welcome Text', 'manzil' ),
		    'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		array(
		    'id'       => 'address_v1',
		    'type'     => 'textarea',
		    'title'    => esc_html__( 'Address', 'manzil' ),
		    'desc'     => esc_html__( 'Enter The Address', 'manzil' ),
		    'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		array(
		    'id'       => 'email_address_v1',
		    'type'     => 'textarea',
		    'title'    => esc_html__( 'Email Address', 'manzil' ),
		    'desc'     => esc_html__( 'Enter The Email Address', 'manzil' ),
		    'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		array(
		    'id'       => 'working_hours_v1',
		    'type'     => 'textarea',
		    'title'    => esc_html__( 'Working Hours', 'manzil' ),
		    'desc'     => esc_html__( 'Enter The Working Hours', 'manzil' ),
		    'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		array(
            'id' => 'search_form_icon_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable Search icon', 'manzil'),
            'default' => false,
			'required' => array( 'header_style_settings', '=', 'header_v1' ),
        ),
		array(
		    'id'       => 'btn_title_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Button Title', 'manzil' ),
		    'desc'     => esc_html__( 'Enter The Button Title', 'manzil' ),
		    'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		array(
		    'id'       => 'btn_link_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Button Link', 'manzil' ),
		    'desc'     => esc_html__( 'Enter The Button Link', 'manzil' ),
		    'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		/***********************************************************************
								Header Version 2 Start
		************************************************************************/
		array(
			'id'       => 'header_v2_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style Two Settings', 'manzil' ),
			'required' => array( 'header_style_settings', '=', 'header_v2' ),
		),
		array(
            'id' => 'show_topbar_v2',
            'type' => 'switch',
            'title' => esc_html__('Show Topbar', 'manzil'),
            'default' => false,
			'required' => array( 'header_style_settings', '=', 'header_v2' ),
        ),
		array(
		    'id'       => 'address_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Address', 'manzil' ),
		    'desc'     => esc_html__( 'Enter The Address', 'manzil' ),
		    'required' => array( 'header_style_settings', '=', 'header_v2' ),
	    ),
		array(
		    'id'       => 'phone_no_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Phone Number', 'manzil' ),
		    'desc'     => esc_html__( 'Enter The Phone Number', 'manzil' ),
		    'required' => array( 'header_style_settings', '=', 'header_v2' ),
	    ),
		array(
			'id'    => 'header_v2_social_share',
			'type'  => 'social_media',
			'title' => esc_html__( 'Social Profiles', 'manzil' ),
			'required' => array( 'header_style_settings', '=', 'header_v2' ),
		),
		array(
            'id' => 'search_form_icon_v2',
            'type' => 'switch',
            'title' => esc_html__('Enable Search icon', 'manzil'),
            'default' => false,
			'required' => array( 'header_style_settings', '=', 'header_v2' ),
        ),
		array(
		    'id'       => 'btn_title_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Button Title', 'manzil' ),
		    'desc'     => esc_html__( 'Enter The Button Title', 'manzil' ),
		    'required' => array( 'header_style_settings', '=', 'header_v2' ),
	    ),
		array(
		    'id'       => 'btn_link_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Button Link', 'manzil' ),
		    'desc'     => esc_html__( 'Enter The Button Link', 'manzil' ),
		    'required' => array( 'header_style_settings', '=', 'header_v2' ),
	    ),
		
		/***********************************************************************
								Header Version 3 Start
		************************************************************************/
		array(
			'id'       => 'header_v3_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style Three Settings', 'manzil' ),
			'required' => array( 'header_style_settings', '=', 'header_v3' ),
		),
		array(
		    'id'       => 'address_v3',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Address', 'manzil' ),
		    'desc'     => esc_html__( 'Enter The Address', 'manzil' ),
		    'required' => array( 'header_style_settings', '=', 'header_v3' ),
	    ),
		array(
		    'id'       => 'phone_no_v3',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Phone Number', 'manzil' ),
		    'desc'     => esc_html__( 'Enter The Phone Number', 'manzil' ),
		    'required' => array( 'header_style_settings', '=', 'header_v3' ),
	    ),
		array(
			'id'    => 'header_v3_social_share',
			'type'  => 'social_media',
			'title' => esc_html__( 'Social Profiles', 'manzil' ),
			'required' => array( 'header_style_settings', '=', 'header_v3' ),
		),
		array(
            'id' => 'search_form_icon_v3',
            'type' => 'switch',
            'title' => esc_html__('Enable Search icon', 'manzil'),
            'default' => true,
			'required' => array( 'header_style_settings', '=', 'header_v3' ),
        ),
		array(
            'id' => 'shopping_cart_icon_v3',
            'type' => 'switch',
            'title' => esc_html__('Enable Shoping Cart Icon', 'manzil'),
            'default' => true,
			'required' => array( 'header_style_settings', '=', 'header_v3' ),
        ),
		array(
            'id' => 'search_form_icon_v3',
            'type' => 'switch',
            'title' => esc_html__('Enable Search icon', 'manzil'),
            'default' => true,
			'required' => array( 'header_style_settings', '=', 'header_v3' ),
        ),
		array(
		    'id'       => 'btn_link_v3',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Button Link', 'manzil' ),
		    'desc'     => esc_html__( 'Enter The Button Link', 'manzil' ),
		    'required' => array( 'header_style_settings', '=', 'header_v3' ),
	    ),
		array(
		    'id'       => 'btn_title_v3',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Button Title', 'manzil' ),
		    'desc'     => esc_html__( 'Enter The Button Title', 'manzil' ),
		    'required' => array( 'header_style_settings', '=', 'header_v3' ),
	    ),
		array(
			'id'       => 'header_style_section_end',
			'type'     => 'section',
			'indent'      => false,
			'required' => [ 'header_source_type', '=', 'd' ],
		),
	),
);
