<?php

return array(
	'title'      => esc_html__( '404 Page Settings', 'manzil' ),
	'id'         => '404_setting',
	'desc'       => '',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'      => '404_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( '404 Source Type', 'manzil' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'manzil' ),
				'e' => esc_html__( 'Elementor', 'manzil' ),
			),
			'default' => 'd',
		),
		array(
			'id'       => '404_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'manzil' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
			],
			'required' => [ '404_source_type', '=', 'e' ],
		),
		array(
			'id'       => '404_default_st',
			'type'     => 'section',
			'title'    => esc_html__( '404 Default', 'manzil' ),
			'indent'   => true,
			'required' => [ '404_source_type', '=', 'd' ],
		),
		array(
			'id'      => '404_page_banner',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Banner', 'manzil' ),
			'desc'    => esc_html__( 'Enable to show banner on blog', 'manzil' ),
			'default' => true,
		),
		array(
			'id'       => '404_banner_title',
			'type'     => 'text',
			'title'    => esc_html__( 'Banner Section Title', 'manzil' ),
			'desc'     => esc_html__( 'Enter the title to show in banner section', 'manzil' ),
			'required' => array( '404_page_banner', '=', true ),
		),
		array(
			'id'       => '404_page_background',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Background Image', 'manzil' ),
			'desc'     => esc_html__( 'Insert background image for banner', 'manzil' ),
			'default'  => '',
			'required' => array( '404_page_banner', '=', true ),
		),
		array(
			'id'    => '404-page_title',
			'type'  => 'text',
			'title' => esc_html__( '404 Title', 'manzil' ),
			'desc'  => esc_html__( 'Enter 404 section title that you want to show', 'manzil' ),
		),
		array(
			'id'    => '404-page_tagline',
			'type'  => 'text',
			'title' => esc_html__( '404 Page Tag Line', 'manzil' ),
			'desc'  => esc_html__( 'Enter 404 section Tag Line that you want to show', 'manzil' ),
		),
		array(
			'id'    => '404-page-text',
			'type'  => 'textarea',
			'title' => esc_html__( '404 Page Description', 'manzil' ),
			'desc'  => esc_html__( 'Enter 404 page description that you want to show.', 'manzil' ),
		),
		array(
			'id'    => 'back_home_btn',
			'type'  => 'switch',
			'title' => esc_html__( 'Show Button', 'manzil' ),
			'desc'  => esc_html__( 'Enable to show back to home button.', 'manzil' ),
			'default'  => true,
		),
		array(
			'id'       => 'back_home_btn_label',
			'type'     => 'text',
			'title'    => esc_html__( 'Button Label', 'manzil' ),
			'desc'     => esc_html__( 'Enter back to home button label that you want to show.', 'manzil' ),
			'default'  => esc_html__( 'Go To Home Page', 'manzil' ),
			'required' => array( 'back_home_btn', '=', true ),
		),
		array(
			'id'     => '404_post_settings_end',
			'type'   => 'section',
			'indent' => false,
		),
	),
);