<?php

namespace MANZILPLUGIN\Inc;


use MANZILPLUGIN\Inc\Abstracts\Taxonomy;


class Taxonomies extends Taxonomy {


	public static function init() {

		$labels = array(
			'name'              => _x( 'Project Category', 'wpmanzil' ),
			'singular_name'     => _x( 'Project Category', 'wpmanzil' ),
			'search_items'      => __( 'Search Category', 'wpmanzil' ),
			'all_items'         => __( 'All Categories', 'wpmanzil' ),
			'parent_item'       => __( 'Parent Category', 'wpmanzil' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpmanzil' ),
			'edit_item'         => __( 'Edit Category', 'wpmanzil' ),
			'update_item'       => __( 'Update Category', 'wpmanzil' ),
			'add_new_item'      => __( 'Add New Category', 'wpmanzil' ),
			'new_item_name'     => __( 'New Category Name', 'wpmanzil' ),
			'menu_name'         => __( 'Project Category', 'wpmanzil' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'project_cat' ),
		);

		register_taxonomy( 'project_cat', 'manzil_project', $args );
		
		//Services Taxonomy Start
		$labels = array(
			'name'              => _x( 'Service Category', 'wpmanzil' ),
			'singular_name'     => _x( 'Service Category', 'wpmanzil' ),
			'search_items'      => __( 'Search Category', 'wpmanzil' ),
			'all_items'         => __( 'All Categories', 'wpmanzil' ),
			'parent_item'       => __( 'Parent Category', 'wpmanzil' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpmanzil' ),
			'edit_item'         => __( 'Edit Category', 'wpmanzil' ),
			'update_item'       => __( 'Update Category', 'wpmanzil' ),
			'add_new_item'      => __( 'Add New Category', 'wpmanzil' ),
			'new_item_name'     => __( 'New Category Name', 'wpmanzil' ),
			'menu_name'         => __( 'Service Category', 'wpmanzil' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'service_cat' ),
		);


		register_taxonomy( 'service_cat', 'manzil_service', $args );
		
		//Testimonials Taxonomy Start
		$labels = array(
			'name'              => _x( 'Testimonials Category', 'wpmanzil' ),
			'singular_name'     => _x( 'Testimonials Category', 'wpmanzil' ),
			'search_items'      => __( 'Search Category', 'wpmanzil' ),
			'all_items'         => __( 'All Categories', 'wpmanzil' ),
			'parent_item'       => __( 'Parent Category', 'wpmanzil' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpmanzil' ),
			'edit_item'         => __( 'Edit Category', 'wpmanzil' ),
			'update_item'       => __( 'Update Category', 'wpmanzil' ),
			'add_new_item'      => __( 'Add New Category', 'wpmanzil' ),
			'new_item_name'     => __( 'New Category Name', 'wpmanzil' ),
			'menu_name'         => __( 'Testimonials Category', 'wpmanzil' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'testimonials_cat' ),
		);


		register_taxonomy( 'testimonials_cat', 'manzil_testimonials', $args );
		
		
		//Team Taxonomy Start
		$labels = array(
			'name'              => _x( 'Team Category', 'wpmanzil' ),
			'singular_name'     => _x( 'Team Category', 'wpmanzil' ),
			'search_items'      => __( 'Search Category', 'wpmanzil' ),
			'all_items'         => __( 'All Categories', 'wpmanzil' ),
			'parent_item'       => __( 'Parent Category', 'wpmanzil' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpmanzil' ),
			'edit_item'         => __( 'Edit Category', 'wpmanzil' ),
			'update_item'       => __( 'Update Category', 'wpmanzil' ),
			'add_new_item'      => __( 'Add New Category', 'wpmanzil' ),
			'new_item_name'     => __( 'New Category Name', 'wpmanzil' ),
			'menu_name'         => __( 'Team Category', 'wpmanzil' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'team_cat' ),
		);


		register_taxonomy( 'team_cat', 'manzil_team', $args );
		
		//Faqs Taxonomy Start
		$labels = array(
			'name'              => _x( 'Faqs Category', 'wpmanzil' ),
			'singular_name'     => _x( 'Faq Category', 'wpmanzil' ),
			'search_items'      => __( 'Search Category', 'wpmanzil' ),
			'all_items'         => __( 'All Categories', 'wpmanzil' ),
			'parent_item'       => __( 'Parent Category', 'wpmanzil' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpmanzil' ),
			'edit_item'         => __( 'Edit Category', 'wpmanzil' ),
			'update_item'       => __( 'Update Category', 'wpmanzil' ),
			'add_new_item'      => __( 'Add New Category', 'wpmanzil' ),
			'new_item_name'     => __( 'New Category Name', 'wpmanzil' ),
			'menu_name'         => __( 'Faq Category', 'wpmanzil' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'faqs_cat' ),
		);


		register_taxonomy( 'faqs_cat', 'manzil_faqs', $args );
	}
	
}
