<?php
/**
 * Abstract class for register post type
 *
 * @package    WordPress
 * @subpackage Student2 Plugin
 * @author     Shahbaz Ahmed <shahbazahmed9@hotmail.com>
 * @version    1.0
 */

namespace MANZILPLUGIN\Inc\Post_Types;

use MANZILPLUGIN\Inc\Abstracts\Post_Type;

if ( ! function_exists( 'add_action' ) ) {
	exit;
}

/**
 * Abstract Post Type
 * Implemented by classes using the same CRUD(s) pattern.
 *
 * @version  2.6.0
 * @package  MANZILPLUGIN/Abstracts
 * @category Abstract Class
 * @author   Wptech
 */
class Testimonials extends Post_Type {

	protected $post_type = 'manzil_testimonials';

	protected $menu_icon = 'dashicons-portfolio';

	protected $taxonomies = array();

	public static $instance;


	/**
	 * [instance description]
	 *
	 * @return [type] [description]
	 */
	public static function instance() {

		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * [init description]
	 *
	 * @return [type] [description]
	 */
	public static function init() {
		
		$post_type = self::instance()->post_type;

		self::instance()->menu_name = esc_html__( 'Testimonials', 'wpfixker' );
		self::instance()->singular  = esc_html__( 'Testimonial', 'wpmanzil' );
		self::instance()->plural    = esc_html__( 'Testimonials', 'wpmanzil' );
		self::instance()->supports  = array( 'title', 'editor', 'excerpt','thumbnail' );
		
		$slug = get_option('manzil_plugin_'.$post_type.'_base');
		self::instance()->slug = $slug ? $slug :  $post_type;

		add_action( 'init', array( self::instance(), 'register' ) );
		
		/**
		 * Adding custom permalink settings to WordPress for specific post types.
		 */
		add_action( 'load-options-permalink.php', [self::instance(), 'permalinks'] );
	}
	
	/**
	 * Permalink Fields.
	 *
	 * @return void
	 */
	public function permalinks() {
		$post_type = $this->post_type;
	    $key = 'manzil_plugin_'.$post_type.'_base';
	    if( isset( $_POST[ $key ] ) ) {
	        update_option( $key, sanitize_title_with_dashes( $_POST[ $key ] ) );
	    }
	    
	    // Add a settings field to the permalink page
	    add_settings_field( $key, sprintf(__( '%s Base' ), $this->singular), [$this, 'permalink_callback'], 'permalink', 'optional' );
	}

	/**
	 * Permalink callback.
	 *
	 * @return void
	 */
	function permalink_callback() {
		$post_type = $this->post_type;
	    $key = 'manzil_plugin_'.$post_type.'_base';

	    $value = get_option( $key );   
	    $value = ($value) ? $value : 'testimonial'; 
	    $is_multi = is_multisite() ? '' : '';

	    echo $is_multi.'<input type="text" value="' . esc_attr( $value ) . '" name="'.$key.'" id="'.$key.'" class="regular-text" />';
	}


}
