<?php
///----Blog widgets---
//Popular Post 
class Manzil_Popular_Post extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Manzil_Popular_Post', /* Name */esc_html__('Manzil Popular Post','manzil'), array( 'description' => esc_html__('Show the Popular Post', 'manzil' )) );
	}
 

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget); ?>
		
        <!--Popular Posts-->
        <div class="popular-posts">
            <?php echo wp_kses_post($before_title.$title.$after_title); ?>
			<?php $query_string = 'posts_per_page='.$instance['number'];
				if( $instance['cat'] ) $query_string .= '&cat='.$instance['cat'];
				$this->posts($query_string);
			?>
        </div>
        
		<?php echo wp_kses_post($after_widget);
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('Popular Post', 'manzil');
		$number = ( $instance ) ? esc_attr($instance['number']) : 3;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';?>
			
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title: ', 'manzil'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('No. of Posts:', 'manzil'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
        </p>
       
    	<p>
            <label for="<?php echo esc_attr($this->get_field_id('categories')); ?>"><?php esc_html_e('Category', 'manzil'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'manzil'), 'selected'=>$cat, 'class'=>'widefat', 'name'=>$this->get_field_name('categories')) ); ?>
        </p>
            
		<?php 
	}
	
	function posts($query_string)
	{
		
		$query = new WP_Query($query_string);
		if( $query->have_posts() ):?>
        
           	<!-- Title -->
			<?php 
				global $post;
				while( $query->have_posts() ): $query->the_post(); 
				$post_thumbnail_id = get_post_thumbnail_id($post->ID);
				$post_thumbnail_url = wp_get_attachment_url($post_thumbnail_id);
			?>
            <article class="post">
                <figure class="post-thumb" style="background-image:url(<?php echo esc_url($post_thumbnail_url);?>);"><a href="<?php echo esc_url(get_the_permalink(get_the_id()));?>" class="overlay-box"><span class="icon fa fa-link"></span></a></figure>
                <div class="text"><a href="<?php echo esc_url(get_the_permalink(get_the_id()));?>"><?php the_title(); ?></a></div>
                <div class="post-info"><?php echo get_the_date();?></div>
            </article>
            <?php endwhile; ?>
            
        <?php endif;
		wp_reset_postdata();
    }
}

//Quick Contact
class Manzil_Quick_Contact extends WP_Widget
{
	
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Manzil_Quick_Contact', /* Name */esc_html__('Manzil Quick Contact','manzil'), array( 'description' => esc_html__('Show the Quick Contact', 'manzil' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget);?>
      		
			<!--Solution Box-->
            <div class="solution-box" style="background-image:url(<?php echo esc_url($instance['bg_img']); ?>)">
                <div class="inner">
                    <div class="title"><?php echo wp_kses_post($instance['subtitle']); ?></div>
                    <h2><?php echo wp_kses_post($instance['title']); ?></h2>
                    <div class="text"><?php echo wp_kses_post($instance['content']); ?></div>
                    <a class="solution-btn theme-btn" href="<?php echo esc_url($instance['btn_link']); ?>"><?php echo wp_kses_post($instance['btn_title']); ?></a>
                </div>
            </div>
            
        <?php
		
		echo wp_kses_post($after_widget);
	}
	
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['bg_img'] = strip_tags($new_instance['bg_img']);
		$instance['subtitle'] = $new_instance['subtitle'];
		$instance['title'] = $new_instance['title'];
		$instance['content'] = $new_instance['content'];
		$instance['btn_title'] = $new_instance['btn_title'];
		$instance['btn_link'] = $new_instance['btn_link'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$bg_img = ($instance) ? esc_attr($instance['bg_img']) : 'http://wp.efforttech.net/newwp/manzil/wp-content/uploads/2020/07/solution.jpg';
		$subtitle = ($instance) ? esc_attr($instance['subtitle']) : '';
		$title = ($instance) ? esc_attr($instance['title']) : '';
		$content = ($instance) ? esc_attr($instance['content']) : '';
		$btn_title = ($instance) ? esc_attr($instance['btn_title']) : '';
		$btn_link = ($instance) ? esc_attr($instance['btn_link']) : '';
		?>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('bg_img')); ?>"><?php esc_html_e('Background Image Url:', 'manzil'); ?></label>
            <input placeholder="<?php esc_attr_e('Background Image Url', 'manzil');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('bg_img')); ?>" name="<?php echo esc_attr($this->get_field_name('bg_img')); ?>" type="text" value="<?php echo esc_attr($bg_img); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('subtitle')); ?>"><?php esc_html_e('Enter Sub Title:', 'manzil'); ?></label>
            <input placeholder="<?php esc_attr_e('Quick Contact', 'manzil');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('subtitle')); ?>" name="<?php echo esc_attr($this->get_field_name('subtitle')); ?>" type="text" value="<?php echo esc_attr($subtitle); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Enter Title:', 'manzil'); ?></label>
            <input placeholder="<?php esc_attr_e('Get Solution', 'manzil');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('content')); ?>"><?php esc_html_e('Content:', 'manzil'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('content')); ?>" name="<?php echo esc_attr($this->get_field_name('content')); ?>" ><?php echo wp_kses_post($content); ?></textarea>
        </p> 
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('btn_title')); ?>"><?php esc_html_e('Enter Button Title:', 'manzil'); ?></label>
            <input placeholder="<?php esc_attr_e('Contact Us', 'manzil');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('btn_title')); ?>" name="<?php echo esc_attr($this->get_field_name('btn_title')); ?>" type="text" value="<?php echo esc_attr($btn_title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('btn_link')); ?>"><?php esc_html_e('Enter Button Link:', 'manzil'); ?></label>
            <input placeholder="<?php esc_attr_e('#', 'manzil');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('btn_link')); ?>" name="<?php echo esc_attr($this->get_field_name('btn_link')); ?>" type="text" value="<?php echo esc_attr($btn_link); ?>" />
        </p>
               
		<?php 
	}
	
}


///----footer widgets---
//About Company
class Manzil_About_Company extends WP_Widget
{
	
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Manzil_About_Company', /* Name */esc_html__('Manzil About Company','manzil'), array( 'description' => esc_html__('Show the About Company', 'manzil' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		
		echo wp_kses_post($before_widget);?>
      		
			<!--Footer Column-->
            <div class="logo-widget">
                <div class="widget-content">
                    <div class="logo">
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url($instance['widget_logo_img']); ?>" data-src="<?php echo esc_url($instance['widget_logo_img']); ?>" alt="<?php esc_attr_e('Awesome Image', 'manzil'); ?>" /></a>
                    </div>
                    <div class="text">
                        <?php echo wp_kses_post($instance['content']); ?>
                    </div>
                    <?php if( $instance['show'] ): ?>
                    <!-- Social Box -->
                    <?php manzil_get_social_icon();?>
                    <?php endif; ?>
                </div>
            </div>
            
        <?php
		
		echo wp_kses_post($after_widget);
	}
	
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['widget_logo_img'] = $new_instance['widget_logo_img'];
		$instance['content'] = $new_instance['content'];
		$instance['show'] = $new_instance['show'];
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$widget_logo_img = ($instance) ? esc_attr($instance['widget_logo_img']) : 'http://wp.efforttech.net/newwp/manzil/wp-content/uploads/2020/07/footer-logo.png';
		$content = ($instance) ? esc_attr($instance['content']) : '';
		$show = ( $instance ) ? esc_attr($instance['show']) : '';
		?>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('widget_logo_img')); ?>"><?php esc_html_e('Logo Image Url:', 'manzil'); ?></label>
            <input placeholder="<?php esc_attr_e('Image Url', 'manzil');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('widget_logo_img')); ?>" name="<?php echo esc_attr($this->get_field_name('widget_logo_img')); ?>" type="text" value="<?php echo esc_attr($widget_logo_img); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('content')); ?>"><?php esc_html_e('Content:', 'manzil'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('content')); ?>" name="<?php echo esc_attr($this->get_field_name('content')); ?>" ><?php echo wp_kses_post($content); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('show')); ?>"><?php esc_html_e('Show Social Icons:', 'manzil'); ?></label>
			<?php $selected = ( $show ) ? ' checked="checked"' : ''; ?>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('show')); ?>"<?php echo esc_attr($selected); ?> name="<?php echo esc_attr($this->get_field_name('show')); ?>" type="checkbox" value="true" />
        </p>
                
		<?php 
	}
	
}

//Contact Details
class Manzil_Contact_Details extends WP_Widget
{
	
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Manzil_Contact_Details', /* Name */esc_html__('Manzil Contact Details','manzil'), array( 'description' => esc_html__('Show the Contact Details', 'manzil' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget);?>
      		
			<!--Footer Column-->
            <div class="contact-widget">
                <?php echo wp_kses_post($before_title.$title.$after_title); ?>
                <ul>
                    <?php if($instance['address']): ?>
                    <li>
                        <span class="icon flaticon-world"></span>
                        <?php echo wp_kses_post($instance['address']); ?>
                    </li>
                    <?php endif; ?>
                    <?php if($instance['email_address']): ?>
                    <li>
                        <span class="icon flaticon-email-3"></span>
                        <?php echo wp_kses_post($instance['email_address']); ?>
                    </li>
                    <?php endif; ?>
                    <?php if($instance['working_hours']): ?>
                    <li>
                        <span class="icon flaticon-clock-3"></span>
                        <?php echo wp_kses_post($instance['working_hours']); ?>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
            
        <?php
		
		echo wp_kses_post($after_widget);
	}
	
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = strip_tags($new_instance['title']);
		$instance['address'] = $new_instance['address'];
		$instance['email_address'] = $new_instance['email_address'];
		$instance['working_hours'] = $new_instance['working_hours'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ($instance) ? esc_attr($instance['title']) : 'Contact Us';
		$address = ($instance) ? esc_attr($instance['address']) : '';
		$email_address = ($instance) ? esc_attr($instance['email_address']) : '';
		$working_hours = ($instance) ? esc_attr($instance['working_hours']) : '';
		?>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Enter Title:', 'manzil'); ?></label>
            <input placeholder="<?php esc_attr_e('Contact Details', 'manzil');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('address')); ?>"><?php esc_html_e('Address:', 'manzil'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('address')); ?>" name="<?php echo esc_attr($this->get_field_name('address')); ?>" ><?php echo wp_kses_post($address); ?></textarea>
        </p> 
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('email_address')); ?>"><?php esc_html_e('Email Address:', 'manzil'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('email_address')); ?>" name="<?php echo esc_attr($this->get_field_name('email_address')); ?>" ><?php echo wp_kses_post($email_address); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('working_hours')); ?>"><?php esc_html_e('Working Hours:', 'manzil'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('working_hours')); ?>" name="<?php echo esc_attr($this->get_field_name('working_hours')); ?>" ><?php echo wp_kses_post($working_hours); ?></textarea>
        </p>
               
		<?php 
	}
	
}

//Resent Post 
class Manzil_Resent_Post extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Manzil_Resent_Post', /* Name */esc_html__('Manzil Resent Post','manzil'), array( 'description' => esc_html__('Show the Resent Post', 'manzil' )) );
	}
 

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget); ?>
		
        
        <!-- Trending Posts -->
        <div class="news-widget">
            <?php echo wp_kses_post($before_title.$title.$after_title); ?>
            <!-- Footer Column -->
            <div class="widget-content">
                <?php $query_string = 'posts_per_page='.$instance['number'];
					if( $instance['cat'] ) $query_string .= '&cat='.$instance['cat'];
					 
					$this->posts($query_string);
				?>
            </div>
        </div>
        
		<?php echo wp_kses_post($after_widget);
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('Resent Post', 'manzil');
		$number = ( $instance ) ? esc_attr($instance['number']) : 2;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';?>
			
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title: ', 'manzil'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('No. of Posts:', 'manzil'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
        </p>
       
    	<p>
            <label for="<?php echo esc_attr($this->get_field_id('categories')); ?>"><?php esc_html_e('Category', 'manzil'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'manzil'), 'selected'=>$cat, 'class'=>'widefat', 'name'=>$this->get_field_name('categories')) ); ?>
        </p>
            
		<?php 
	}
	
	function posts($query_string)
	{
		
		$query = new WP_Query($query_string);
		if( $query->have_posts() ):?>
        
           	<!-- Title -->
			<?php 
				global $post;
				while( $query->have_posts() ): $query->the_post(); 
				$post_thumbnail_id = get_post_thumbnail_id($post->ID);
				$post_thumbnail_url = wp_get_attachment_url($post_thumbnail_id);
			?>
            <div class="post">
                <div class="thumb" style="background-image:url(<?php echo esc_url($post_thumbnail_url);?>);"></div>
                <h6><a href="<?php echo esc_url(get_the_permalink(get_the_id()));?>"><?php echo wp_trim_words( get_the_title(), 5, '...' );?></a></h6>
                <span class="date"><?php echo get_the_date();?></span>
            </div>
            <?php endwhile; ?>
            
        <?php endif;
		wp_reset_postdata();
    }
}



///----Service Sidebar widgets---
//Our Brochures
class Manzil_Brochures extends WP_Widget
{
	
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Manzil_Brochures', /* Name */esc_html__('Manzil Our Brochures','manzil'), array( 'description' => esc_html__('Show the info Our Brochures', 'manzil' )) );
	}
	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget);?>
      		
            <!-- Brochures Widget -->
            <div class="brochures-widget">
                <div class="widget-content">
                    <div class="sidebar-title">
                        <?php echo wp_kses_post($before_title.$title.$after_title); ?>
                    </div>
                    <div class="text"><?php echo wp_kses_post($instance['content']); ?></div>
                    <?php if($instance['pdf_file_link']): ?>
                    <!-- Broucher Box -->
                    <div class="broucher-box">
                        <a href="<?php echo wp_kses_post($instance['pdf_file_link']); ?>" class="overlay-link"></a>
                        <div class="broucher-inner">
                            <span class="file-icon fa fa-file-pdf-o"></span>
                            <?php echo wp_kses_post($instance['pdf_file_title']); ?>
                            <span class="download-icon flaticon-computing-cloud"></span>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php if($instance['word_file_link']): ?>
                    <!-- Broucher Box -->
                    <div class="broucher-box">
                        <a href="<?php echo wp_kses_post($instance['word_file_link']); ?>" class="overlay-link"></a>
                        <div class="broucher-inner">
                            <span class="file-icon fa fa-file-word-o"></span>
                            <?php echo wp_kses_post($instance['word_file_title']); ?>
                            <span class="download-icon flaticon-computing-cloud"></span>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php if($instance['ppt_file_link']): ?>
                    <!-- Broucher Box -->
                    <div class="broucher-box">
                        <a href="<?php echo wp_kses_post($instance['ppt_file_link']); ?>" class="overlay-link"></a>
                        <div class="broucher-inner">
                            <span class="file-icon fa fa-file-powerpoint-o"></span>
                            <?php echo wp_kses_post($instance['ppt_file_title']); ?>
                            <span class="download-icon flaticon-computing-cloud"></span>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            
		<?php
		
		echo wp_kses_post($after_widget);
	}
	
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = $new_instance['title'];
		$instance['content'] = $new_instance['content'];
		$instance['pdf_file_title'] = $new_instance['pdf_file_title'];
		$instance['pdf_file_link'] = $new_instance['pdf_file_link'];
		$instance['word_file_title'] = $new_instance['word_file_title'];
		$instance['word_file_link'] = $new_instance['word_file_link'];
		$instance['ppt_file_title'] = $new_instance['ppt_file_title'];
		$instance['ppt_file_link'] = $new_instance['ppt_file_link'];
		
		
		return $instance;
	}
	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ($instance) ? esc_attr($instance['title']) : 'Brochures';
		$content = ($instance) ? esc_attr($instance['content']) : '';
		$pdf_file_title = ($instance) ? esc_attr($instance['pdf_file_title']) : '';
		$pdf_file_link = ($instance) ? esc_attr($instance['pdf_file_link']) : '';
		$word_file_title = ($instance) ? esc_attr($instance['word_file_title']) : '';
		$word_file_link = ($instance) ? esc_attr($instance['word_file_link']) : '';
		$ppt_file_title = ($instance) ? esc_attr($instance['ppt_file_title']) : '';
		$ppt_file_link = ($instance) ? esc_attr($instance['ppt_file_link']) : '';
		
		?>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'manzil'); ?></label>
            <input placeholder="<?php esc_attr_e('Enter Title', 'manzil');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('content')); ?>"><?php esc_html_e('Content:', 'manzil'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('content')); ?>" name="<?php echo esc_attr($this->get_field_name('content')); ?>" ><?php echo wp_kses_post($content); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('pdf_file_title')); ?>"><?php esc_html_e('PDF Title:', 'manzil'); ?></label>
            <input placeholder="<?php esc_attr_e('PDF Title', 'manzil');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('pdf_file_title')); ?>" name="<?php echo esc_attr($this->get_field_name('pdf_file_title')); ?>" type="text" value="<?php echo esc_attr($pdf_file_title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('pdf_file_link')); ?>"><?php esc_html_e('PDF Link:', 'manzil'); ?></label>
            <input placeholder="<?php esc_attr_e('#', 'manzil');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('pdf_file_link')); ?>" name="<?php echo esc_attr($this->get_field_name('pdf_file_link')); ?>" type="text" value="<?php echo esc_attr($pdf_file_link); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('word_file_title')); ?>"><?php esc_html_e('Word File Title:', 'manzil'); ?></label>
            <input placeholder="<?php esc_attr_e('Word File Title', 'manzil');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('word_file_title')); ?>" name="<?php echo esc_attr($this->get_field_name('word_file_title')); ?>" type="text" value="<?php echo esc_attr($word_file_title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('word_file_link')); ?>"><?php esc_html_e('Word File Link:', 'manzil'); ?></label>
            <input placeholder="<?php esc_attr_e('#', 'manzil');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('word_file_link')); ?>" name="<?php echo esc_attr($this->get_field_name('word_file_link')); ?>" type="text" value="<?php echo esc_attr($word_file_link); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('ppt_file_title')); ?>"><?php esc_html_e('PPT File Title:', 'manzil'); ?></label>
            <input placeholder="<?php esc_attr_e('PPT File Title', 'manzil');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('ppt_file_title')); ?>" name="<?php echo esc_attr($this->get_field_name('ppt_file_title')); ?>" type="text" value="<?php echo esc_attr($ppt_file_title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('ppt_file_link')); ?>"><?php esc_html_e('PPT File Link:', 'manzil'); ?></label>
            <input placeholder="<?php esc_attr_e('#', 'manzil');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('ppt_file_link')); ?>" name="<?php echo esc_attr($this->get_field_name('ppt_file_link')); ?>" type="text" value="<?php echo esc_attr($ppt_file_link); ?>" />
        </p>
               
		<?php 
	}
	
}

//Contact Us
class Manzil_Contact_Us extends WP_Widget
{
	
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Manzil_Contact_Us', /* Name */esc_html__('Manzil Contact Us','manzil'), array( 'description' => esc_html__('Show the Service Contact Us', 'manzil' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		echo wp_kses_post($before_widget);?>
      		
			<div class="contact-widget">
                <div class="widget-content">
                    <div class="sidebar-title">
                        <?php echo wp_kses_post($before_title.$title.$after_title); ?>
                    </div>
                    
                    <ul>
                        <?php if($instance['address']): ?>
                        <li>
                            <span class="icon flaticon-road-sign"></span>
                            <?php echo wp_kses_post($instance['address']); ?>
                        </li>
                        <?php endif; ?>
                        <?php if($instance['email_address']): ?>
                        <li>
                            <span class="icon flaticon-email-6"></span>
                            <?php echo wp_kses_post($instance['email_address']); ?>
                        </li>
                        <?php endif; ?>
                        <?php if($instance['working_hours']): ?>
                        <li>
                            <span class="icon flaticon-clock-3"></span>
                            <?php echo wp_kses_post($instance['working_hours']); ?>
                        </li>
                        <?php endif; ?>
                    </ul>
                    
                </div>
            </div>
            
        <?php
		
		echo wp_kses_post($after_widget);
	}
	
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['address'] = $new_instance['address'];
		$instance['email_address'] = $new_instance['email_address'];
		$instance['working_hours'] = $new_instance['working_hours'];
		
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		
		$title = ($instance) ? esc_attr($instance['title']) : 'Contact Us';
		$address = ($instance) ? esc_attr($instance['address']) : '';
		$email_address = ($instance) ? esc_attr($instance['email_address']) : '';
		$working_hours = ($instance) ? esc_attr($instance['working_hours']) : '';
		
		?>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Enter Title:', 'manzil'); ?></label>
            <input placeholder="<?php esc_attr_e('Contact Details', 'manzil');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('address')); ?>"><?php esc_html_e('Address:', 'manzil'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('address')); ?>" name="<?php echo esc_attr($this->get_field_name('address')); ?>" ><?php echo wp_kses_post($address); ?></textarea>
        </p> 
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('email_address')); ?>"><?php esc_html_e('Email Address:', 'manzil'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('email_address')); ?>" name="<?php echo esc_attr($this->get_field_name('email_address')); ?>" ><?php echo wp_kses_post($email_address); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('working_hours')); ?>"><?php esc_html_e('Working Hours:', 'manzil'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('working_hours')); ?>" name="<?php echo esc_attr($this->get_field_name('working_hours')); ?>" ><?php echo wp_kses_post($working_hours); ?></textarea>
        </p>
               
                
		<?php 
	}
	
}

