<?php

namespace MANZILPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Why_Choose_Us extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'manzil_why_choose_us';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Why Choose Us', 'manzil' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'manzil' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'why_choose_us',
			[
				'label' => esc_html__( 'Why Choose Us', 'manzil' ),
			]
		);
		$this->add_control(
			'about_image',
				[
				  'label' => __( 'About Image', 'manzil' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				  
				]
	    );
		$this->add_control(
			'image_caption',
			[
				'label'       => __( 'Image Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Image Title', 'manzil' ),
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Sub Heading', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Heading', 'manzil' ),
			]
		);
		$this->add_control(
			'text1',
			[
				'label'       => __( 'Description', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'manzil' ),
			]
		);
		$this->add_control(
			'feature_str',
			[
				'label'       => __( 'Feature List', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Feature List', 'manzil' ),
			]
		);
		$this->add_control(
			'feature_str_two',
			[
				'label'       => __( 'Feature List Two', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Feature List Two', 'manzil' ),
			]
		);
		$this->add_control(
            'style_two',
			[
				'label'   => esc_html__( 'Choose Spacing Style', 'manzil' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'one',
				'options' => array(
					'one' => esc_html__( 'Choose Spacing Style One', 'manzil' ),
					'two'  => esc_html__( 'Choose Spacing Style Two', 'manzil' ),
				),
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>
        
        <!-- Reason Section -->
        <section class="reason-section <?php if($settings['style_two'] == 'two') echo 'style-two'; else echo '' ;?>">
            <div class="auto-container">
                <div class="row clearfix">
                    <!-- Image Column -->
                    <div class="image-column col-lg-7 col-md-12 col-sm-12">
                        <div class="inner-column wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <div class="image">
                                <img src="<?php echo $settings['about_image']['url'];?>" alt="<?php esc_attr_e('Awesome Image', 'manzil'); ?>" />
                            </div>
                            <div class="image-text">
                                <div class="text"><?php echo wp_kses( $settings['image_caption'], $allowed_tags );?></div>
                            </div>
                        </div>
                    </div>
                    <!-- Content Column -->
                    <div class="content-column col-lg-5 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <!-- Sec Title -->
                            <div class="sec-title">
                                <div class="title">
                                    <!-- Title Effect -->
                                    <div class="title-effect">
                                        <div class="bar bar-top"></div>
                                        <div class="bar bar-right"></div>
                                        <div class="bar bar-bottom"></div>
                                        <div class="bar bar-left"></div>
                                    </div>
                                    <?php echo wp_kses( $settings['subtitle'], $allowed_tags );?>
                                </div>
                                <h2><?php echo wp_kses( $settings['title'], $allowed_tags );?></h2>
                            </div>
                            <div class="bold-text"><?php echo wp_kses( $settings['text'], $allowed_tags );?></div>
                            <div class="text"><?php echo wp_kses( $settings['text1'], $allowed_tags );?></div>
                            <div class="row clearfix">
                                <div class="column col-lg-6 col-md-6 col-sm-12">
                                    <ul class="list-style-one">
                                        <?php $fearures = explode("\n", ($settings['feature_str']));?>
										<?php foreach($fearures as $feature):?>
                                        <li><?php echo wp_kses($feature, true); ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                                <div class="column col-lg-6 col-md-6 col-sm-12">
                                    <ul class="list-style-one">
                                        <?php $fearures_one = explode("\n", ($settings['feature_str_two']));?>
										<?php foreach($fearures_one as $feature_one):?>
                                        <li><?php echo wp_kses($feature_one, true); ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Reason Section -->
                  
		<?php 
	}

}
