<?php

namespace MANZILPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Terms_And_Condition extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'manzil_terms_and_condition';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Terms and Condition', 'manzil' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'manzil' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'terms_and_condition',
			[
				'label' => esc_html__( 'Terms and Condition', 'manzil' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'manzil' ),
			]
		);
		$this->add_control(
			'date',
			[
				'label'       => __( 'Enter The Date', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Date', 'manzil' ),
			]
		);
		$this->add_control(
			'text1',
			[
				'label'       => __( 'Description', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'manzil' ),
			]
		);
		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Sub Heading', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Heading', 'manzil' ),
			]
		);
		$this->add_control(
			'text2',
			[
				'label'       => __( 'Description', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'manzil' ),
			]
		);
		$this->add_control(
			'subheading2',
			[
				'label'       => __( 'Sub Heading', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Heading', 'manzil' ),
			]
		);
		$this->add_control(
			'text3',
			[
				'label'       => __( 'Description', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'manzil' ),
			]
		);
		$this->add_control(
			'subheading3',
			[
				'label'       => __( 'Sub Heading', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Heading', 'manzil' ),
			]
		);
		$this->add_control(
			'text4',
			[
				'label'       => __( 'Description', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'manzil' ),
			]
		);
		$this->add_control(
			'feature_str',
			[
				'label'       => __( 'Feature List', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Feature List', 'manzil' ),
			]
		);
		$this->add_control(
              'privacy_description', 
			  	[
            		'type' => Controls_Manager::REPEATER,
            		'seperator' => 'before',
            		'default' => 
						[
                			['subheading4' => esc_html__('The standard chunk', 'manzil')],
                			['subheading4' => esc_html__('Security and Retention', 'manzil')],
                			['subheading4' => esc_html__('Contact Us', 'manzil')]
            			],
            		'fields' => 
						[
							[
                    			'name' => 'subheading4',
                    			'label' => esc_html__('Title', 'manzil'),
                    			'type' => Controls_Manager::TEXTAREA,
                    			'default' => esc_html__('', 'manzil')
                			],
							[
                    			'name' => 'text5',
                    			'label' => esc_html__('Description', 'manzil'),
                    			'type' => Controls_Manager::TEXTAREA,
                    			'default' => esc_html__('', 'manzil')
                			],
            			],
            	    'title_field' => '{{subheading4}}',
                 ]
        );
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>
        
        <!-- Privacy Section -->
        <section class="privacy-section">
            <div class="auto-container">
                <!-- Privacy Content -->
                <div class="privacy-content">
                    <?php if($settings['title']):?><h2><?php echo wp_kses( $settings['title'], $allowed_tags );?></h2><?php endif; ?>
                    <?php if($settings['text']):?><?php echo wp_kses( $settings['text'], $allowed_tags );?><?php endif; ?>
                    <?php if($settings['date']):?><div class="date"><?php echo wp_kses( $settings['date'], $allowed_tags );?></div><?php endif; ?>
                    <?php if($settings['text1']):?><?php echo wp_kses( $settings['text1'], $allowed_tags );?><?php endif; ?>
                    <?php if($settings['subheading']):?><h2><?php echo wp_kses( $settings['subheading'], $allowed_tags );?></h2><?php endif; ?>
                    <?php if($settings['text2']):?><?php echo wp_kses( $settings['text2'], $allowed_tags );?><?php endif; ?>
                </div>
                <!-- Privacy Content -->
                <?php if($settings['subheading2']):?>
                <div class="privacy-content">
                    <h4><?php echo wp_kses( $settings['subheading2'], $allowed_tags );?></h4>
                    <?php echo wp_kses( $settings['text3'], $allowed_tags );?>
                </div>
                <?php endif; ?>
                <?php if($settings['subheading3']):?>
                <!-- Privacy Content -->
                <div class="privacy-content">
                    <h4><?php echo wp_kses( $settings['subheading3'], $allowed_tags );?></h4>
                    <?php echo wp_kses( $settings['text4'], $allowed_tags );?>
                    <ul class="privacy-list">
                        <?php $fearures = explode("\n", ($settings['feature_str']));?>
						<?php foreach($fearures as $feature):?>
                        <li><?php echo wp_kses($feature, true); ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>
				<?php foreach($settings['privacy_description'] as $item):?>
                <?php if($item['subheading4']):?>
                <!-- Privacy Content -->
                <div class="privacy-content">
                    <h4><?php echo wp_kses( $item['subheading4'], $allowed_tags );?></h4>
                    <?php echo wp_kses( $item['text5'], $allowed_tags );?>
                </div>
                <?php endif; endforeach; ?>
            </div>
        </section>
        <!-- End Privacy Section -->
         
		<?php 
	}

}
