<?php

namespace MANZILPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Team_Details extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'manzil_team_details';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Team Details', 'manzil' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'manzil' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'team_details',
			[
				'label' => esc_html__( 'Team Details', 'manzil' ),
			]
		);
		$this->add_control(
			'about_image',
				[
				  'label' => __( 'Image', 'manzil' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				  
				]
	    );
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
			]
		);
		$this->add_control(
			'designation',
			[
				'label'       => __( 'Designation', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Designation', 'manzil' ),
			]
		);
		$this->add_control(
			'email_address',
			[
				'label'       => __( 'Email Address', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Email Address', 'manzil' ),
			]
		);
		$this->add_control(
			'fax_no',
			[
				'label'       => __( 'Fax Number', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Fax Number', 'manzil' ),
			]
		);
		$this->add_control(
			'phone_no',
			[
				'label'       => __( 'Phone Number', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Phone Number', 'manzil' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'manzil' ),
			]
		);
		$this->add_control(
			'feature_str',
			[
				'label'       => __( 'Feature List', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Feature List', 'manzil' ),
			]
		);
		$this->add_control(
			'feature_str_two',
			[
				'label'       => __( 'Feature List Two', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Feature List Two', 'manzil' ),
			]
		);
		$this->add_control(
              'social_icon', 
			  	[
            		'type' => Controls_Manager::REPEATER,
            		'seperator' => 'before',
            		'default' => 
						[
                			['social_link' => esc_html__('https://www.facebook.com/', 'manzil')],
                			['social_link' => esc_html__('https://www.twitter.com/', 'manzil')],
                			['social_link' => esc_html__('https://www.linkedin.com/', 'manzil')]
            			],
            		'fields' => 
						[
                			[
                    			'name' => 'icons',
                    			'label' => esc_html__('Enter The icons', 'manzil'),
                    			'type' => Controls_Manager::SELECT,
                    			'options'  => get_fontawesome_icons(),
                			],
							[
                    			'name' => 'social_link',
								'label' => __( 'Social Url', 'manzil' ),
							    'type' => Controls_Manager::URL,
							    'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
							    'show_external' => true,
							    'default' => ['url' => '','is_external' => true,'nofollow' => true,],
                			],
            			],
            	    'title_field' => '{{social_link}}',
                 ]
        );
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		
		?>
        
        <!-- Team Detail Section -->
        <section class="team-single-section">
            <div class="auto-container">
                <div class="row clearfix">
                    
                    <!-- Image Column -->
                    <div class="image-column col-lg-4 col-md-12 col-sm-12">
                        <div class="inner-column wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <div class="image">
                                <img src="<?php echo $settings['about_image']['url'];?>" alt="<?php esc_attr_e('Awesome Image', 'manzil'); ?>" />
                            </div>
                        </div>
                    </div>
                    
                    <!-- Content Column -->
                    <div class="content-column col-lg-8 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <h2><?php echo wp_kses( $settings['title'], $allowed_tags );?> <?php if($settings['designation']): ?><span class="category"><?php echo wp_kses( $settings['designation'], $allowed_tags );?></span><?php endif; ?></h2>
                            <ul class="post-meta">
                                <?php if($settings['email_address']): ?><li><span class="icon flaticon-email-6"></span> <a href="mailto:<?php echo esc_url( $settings['email_address']);?>"><?php echo wp_kses( $settings['email_address'], $allowed_tags );?></a></li><?php endif; ?>
                                <?php if($settings['fax_no']): ?><li><span class="icon flaticon-24-hours-phone-service"></span> <a href="tel:<?php echo esc_url( $settings['fax_no']);?>"><?php echo wp_kses( $settings['fax_no'], $allowed_tags );?></a></li><?php endif; ?>
                                <?php if($settings['phone_no']): ?><li><span class="icon fa fa-whatsapp"></span> <a href="tel:<?php echo esc_url( $settings['phone_no']);?>"><?php echo wp_kses( $settings['phone_no'], $allowed_tags );?></a></li><?php endif; ?>
                            </ul>
                            <?php if($settings['text']): ?>
                            <div class="text">
                                <?php echo wp_kses( $settings['text'], $allowed_tags );?>
                            </div>
                            <?php endif; ?>
                            <div class="row clearfix">
                                <?php if($settings['feature_str']): ?>
                                <div class="column col-lg-6 col-md-6 col-sm-12">
                                    <ul class="list-style-one">
                                        <?php $fearures = explode("\n", ($settings['feature_str']));?>
                                        <?php foreach($fearures as $feature):?>
                                        <li><?php echo wp_kses($feature, true); ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                                <?php endif; ?>
                                <?php if($settings['feature_str_two']): ?>
                                <div class="column col-lg-6 col-md-6 col-sm-12">
                                    <ul class="list-style-one">
                                        <?php $fearures_one = explode("\n", ($settings['feature_str_two']));?>
                                        <?php foreach($fearures_one as $feature_one):?>
                                        <li><?php echo wp_kses($feature_one, true); ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                                <?php endif; ?>
                            </div>
                            
                            <!-- Social Box -->
                            <ul class="social-icon-one">
                                <?php foreach($settings['social_icon'] as $item):?>
                                <li><a href="<?php echo esc_url($item['social_link']['url']); ?>" class="fa <?php echo esc_attr($item['icons']); ?>"></a></li>
                                <?php endforeach;?>
                            </ul>
                        </div>
                    </div>
                    
                </div>
            </div>
        </section>
        <!-- End Team Detail Section -->
         
		<?php 
	}

}
