<?php

namespace MANZILPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Related_Project extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'manzil_related_project';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Related Project', 'manzil' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'manzil' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'related_project',
			[
				'label' => esc_html__( 'Related Project', 'manzil' ),
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub title', 'manzil' ),
				'default'     => __( 'Related Project', 'manzil' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'manzil' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'manzil' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'manzil' ),
					'title'      => esc_html__( 'Title', 'manzil' ),
					'menu_order' => esc_html__( 'Menu Order', 'manzil' ),
					'rand'       => esc_html__( 'Random', 'manzil' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'manzil' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESc' => esc_html__( 'DESC', 'manzil' ),
					'ASC'  => esc_html__( 'ASC', 'manzil' ),
				),
			]
		);
		$this->add_control(
			'query_exclude',
			[
				'label'       => esc_html__( 'Exclude', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'Exclude posts, pages, etc. by ID with comma separated.', 'manzil' ),
			]
		);
		$this->add_control(
            'query_category', 
				[
				  'type' => Controls_Manager::SELECT,
				  'label' => esc_html__('Category', 'manzil'),
				  'options' => get_project_categories()
				]
		);
		$this->add_control(
            'style_two',
			[
				'label'   => esc_html__( 'Choose Spacing Style', 'manzil' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'one',
				'options' => array(
					'one' => esc_html__( 'Choose Spacing Style One', 'manzil' ),
					'two'  => esc_html__( 'Choose Spacing Style Two', 'manzil' ),
				),
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = get_query_var('paged');
		$paged = manzil_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-manzil' );
		$args = array(
			'post_type'      => 'manzil_project',
			'posts_per_page' => manzil_set( $settings, 'query_number' ),
			'orderby'        => manzil_set( $settings, 'query_orderby' ),
			'order'          => manzil_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		if ( manzil_set( $settings, 'query_exclude' ) ) {
			$settings['query_exclude'] = explode( ',', $settings['query_exclude'] );
			$args['post__not_in']      = manzil_set( $settings, 'query_exclude' );
		}
		if( manzil_set( $settings, 'query_category' ) ) $args['project_cat'] = manzil_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );

		if ( $query->have_posts() ) 
		{ ?>
		
        <!-- Project Related Section -->
        <section class="project-related-section <?php if($settings['style_two'] == 'two') echo ''; else echo 'style-two' ;?>">
            <div class="auto-container">
                <!-- Sec Title -->
                <div class="sec-title centered">
                    <div class="title">
                        <!-- Title Effect -->
                        <div class="title-effect">
                            <div class="bar bar-top"></div>
                            <div class="bar bar-right"></div>
                            <div class="bar bar-bottom"></div>
                            <div class="bar bar-left"></div>
                        </div>
                        <?php echo wp_kses( $settings['subtitle'], $allowed_tags );?>
                    </div>
                    <h2><?php echo wp_kses( $settings['title'], $allowed_tags );?></h2>
                </div>
                
                <div class="three-item-carousel owl-carousel owl-theme">
                    <?php 
						global  $post;
						
						while ( $query->have_posts() ) : $query->the_post(); 
						$term_list = wp_get_post_terms(get_the_id(), 'project_cat', array("fields" => "names"));
						
						$post_thumbnail_id = get_post_thumbnail_id($post->ID);
						$post_thumbnail_url = wp_get_attachment_url($post_thumbnail_id);
					?>
                    <!-- Gallery Block -->
                    <div class="gallery-block">
                        <div class="inner-box">
                            <figure class="image-box">
                                <?php the_post_thumbnail('manzil_370x370'); ?>
                                <!-- Overlay Box -->
                                <div class="overlay-box">
                                    <div class="overlay-inner">
                                        <div class="content">
                                            <h6><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'ext_url', true ));?>"><?php the_title(); ?></a></h6>
                                            <div class="category"><?php echo implode( ', ', (array)$term_list );?></div>
                                        </div>
                                    </div>
                                </div>
                                <a href="<?php echo esc_url($post_thumbnail_url); ?>" data-fancybox="gallery-1" data-caption="" class="link"><span class="icon flaticon-full-screen"></span></a>
                            </figure>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
                
            </div>
        </section>
        <!-- End Project Related Section -->
        
        <?php }
		wp_reset_postdata();
	}

}
