<?php

namespace MANZILPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Project_Details extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'manzil_project_details';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Project Details', 'manzil' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'manzil' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'project_details',
			[
				'label' => esc_html__( 'Project Details', 'manzil' ),
			]
		);
		$this->add_control(
			'sidebar_slug',
			[
				'label'   => esc_html__( 'Choose Sidebar', 'manzil' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'Choose Sidebar',
				'options'  => manzil_get_sidebars(),
			]
		);
		$this->add_control(
              'slider_image', 
			  	[
				'type' => Controls_Manager::REPEATER,
				'seperator' => 'before',
				'fields' => 
					[
						[
							'name' => 'slide_img',
							'label' => __( 'Slide Image', 'manzil' ),
							'type' => Controls_Manager::MEDIA,
							'default' => ['url' => Utils::get_placeholder_image_src(),],
						],
					],
               ]
        );
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'manzil' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'manzil' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'manzil' ),
			]
		);
		$this->add_control(
			'text1',
			[
				'label'       => __( 'Description', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'manzil' ),
			]
		);
		$this->add_control(
              'project_info', 
			  	[
            		'type' => Controls_Manager::REPEATER,
            		'seperator' => 'before',
            		'default' => 
						[
                			['project_info_title' => esc_html__('Category:', 'manzil')],
                			['project_info_title' => esc_html__('Tags:', 'manzil')],
                			['project_info_title' => esc_html__('Launch Date:', 'manzil')]
            			],
            		'fields' => 
						[
                			[
                    			'name' => 'project_info_title',
                    			'label' => esc_html__('Project Title', 'manzil'),
                    			'type' => Controls_Manager::TEXT,
                    			'default' => esc_html__('', 'manzil')
                			],
							[
                    			'name' => 'project_info_text',
                    			'label' => esc_html__('Description', 'manzil'),
                    			'type' => Controls_Manager::TEXTAREA,
                    			'default' => esc_html__('', 'manzil')
                			],
            			],
            	    'title_field' => '{{project_info_title}}',
                 ]
        );
		$this->add_control(
              'social_info', 
			  	[
            		'type' => Controls_Manager::REPEATER,
            		'seperator' => 'before',
            		'default' => 
						[
                			['social_link' => esc_html__('#', 'manzil')],
            			],
            		'fields' => 
						[
                			[
                    			'name' => 'social_icon',
                    			'label' => esc_html__('Enter The icons', 'manzil'),
                    			'type' => Controls_Manager::SELECT,
                    			'options'  => get_fontawesome_icons(),
                			],
							[
                    			'name' => 'social_link',
								'label' => __( 'Social Url', 'manzil' ),
							    'type' => Controls_Manager::URL,
							    'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
							    'show_external' => true,
							    'default' => ['url' => '','is_external' => true,'nofollow' => true,],
                			],
            			],
            	    'title_field' => '{{social_link}}',
                 ]
        );
		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Heading', 'manzil' ),
			]
		);
		$this->add_control(
			'text2',
			[
				'label'       => __( 'Description', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'manzil' ),
			]
		);
		$this->add_control(
			'sub_heading2',
			[
				'label'       => __( 'Sub Heading', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Heading', 'manzil' ),
			]
		);
		$this->add_control(
			'text3',
			[
				'label'       => __( 'Description', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'manzil' ),
			]
		);
		$this->add_control(
			'sub_heading3',
			[
				'label'       => __( 'Sub Heading', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Heading', 'manzil' ),
			]
		);
		$this->add_control(
			'text4',
			[
				'label'       => __( 'Description', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'manzil' ),
			]
		);
		$this->add_control(
			'chart_img',
				[
				  'label' => __( 'Chart Image', 'manzil' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
	    );
		$this->add_control(
			'text5',
			[
				'label'       => __( 'Description', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'manzil' ),
			]
		);
		$this->add_control(
            'style_two',
			[
				'label'   => esc_html__( 'Choose Project Style', 'manzil' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'one',
				'options' => array(
					'one' => esc_html__( 'Project Full Width', 'manzil' ),
					'two'  => esc_html__( 'Project With Sidebar', 'manzil' ),
				),
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>
        
        <?php if($settings['style_two'] == 'two'): ?>
        
        <!-- Sidebar Page Container -->
        <div class="sidebar-page-container">
            <div class="auto-container">
                <div class="row clearfix">
                    
                    <!-- Content Side -->
                    <div class="content-side col-lg-8 col-md-12 col-sm-12">
                        <!-- Gallery Detail Section -->
                        <div class="gallery-detail-section style-two">
                            <div class="inner-container">
                                <div class="inner-box">
                                    <div class="carousel-boxed">
                                        <div class="single-item-carousel owl-carousel owl-theme">
                                            
                                            <?php foreach($settings['slider_image'] as $key => $item):?>
                                            <div class="slide">
                                                <div class="image">
                                                    <img src="<?php echo esc_url( $item['slide_img']['url'] );?>" alt="<?php esc_attr_e('Awesome Image', 'manzil'); ?>" />
                                                </div>
                                            </div>
                                            <?php endforeach;?>
                                            
                                        </div>
                                    </div>
                                    <div class="lower-content">
                                        <div class="title"><?php echo wp_kses( $settings['subtitle'], $allowed_tags );?></div>
                                        <h2><?php echo wp_kses( $settings['title'], $allowed_tags );?></h2>
                                        <div class="row clearfix">
                                            <div class="column col-lg-6 col-md-12 col-sm-12">
                                                <?php echo wp_kses( $settings['text'], $allowed_tags );?>
                                            </div>
                                            <div class="column col-lg-6 col-md-12 col-sm-12">
                                                <div class="project-info-boxed">
                                                    <ul>
                                                        <?php foreach($settings['project_info'] as $key => $item):?>
                                                        <li><span><?php echo wp_kses($item['project_info_title'], $allowed_tags);?></span><?php echo wp_kses($item['project_info_text'], $allowed_tags);?></li>
                                                        <?php endforeach;?>
                                                        
                                                        <li><span><?php esc_html_e('Share:', 'manzil'); ?></span>
                                                            <?php foreach($settings['social_info'] as $key => $items):?>
                                                            <a href="<?php echo esc_url($items['social_link']['url']);?>" class="fa <?php echo esc_attr($items['social_icon']);?>"></a>
                                                            <?php endforeach;?>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <?php echo wp_kses( $settings['text1'], $allowed_tags );?>
                                        <h3><?php echo wp_kses( $settings['sub_heading'], $allowed_tags );?></h3>
                            			<p><?php echo wp_kses( $settings['text2'], $allowed_tags );?></p>
                                        <div class="row clearfix">
                                            <div class="column col-lg-5 col-md-12 col-sm-12">
                                                <h3><?php echo wp_kses( $settings['sub_heading2'], $allowed_tags );?></h3>
                                    			<p><?php echo wp_kses( $settings['text3'], $allowed_tags );?></p>
                                            </div>
                                            <div class="column col-lg-7 col-md-12 col-sm-12">
                                                <div class="chart-image">
                                                    <img src="<?php echo esc_url( $settings['chart_img']['url'] );?>" alt="<?php esc_attr_e('Awesome Image', 'manzil'); ?>" />
                                                </div>
                                            </div>
                                        </div>
                                        <h3><?php echo wp_kses( $settings['sub_heading3'], $allowed_tags );?></h3>
                                    	<p><?php echo wp_kses( $settings['text4'], $allowed_tags );?></p>
                                        <p><?php echo wp_kses( $settings['text5'], $allowed_tags );?></p>
                                    </div>
                                </div>
                            </div>
                            
                        </div>
                        <!-- End Gallery Detail Section -->
                    </div>
                    
                    <!-- Sidebar Side -->
                    <div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
                        <aside class="sidebar sticky-top">
                            <?php if ( is_active_sidebar( $settings['sidebar_slug'] ) ) : ?>
								<?php dynamic_sidebar( $settings['sidebar_slug'] ); ?>
                            <?php endif; ?>
                        </aside>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Sidebar Page Container -->
        
        <?php else: ?>
        
        <!-- Gallery Detail Section -->
        <section class="gallery-detail-section">
            <div class="auto-container">
                <div class="inner-container">
                    <div class="inner-box">
                        <div class="carousel-boxed">
                            <div class="single-item-carousel owl-carousel owl-theme">
                                <?php foreach($settings['slider_image'] as $key => $item):?>
                                <div class="slide">
                                    <div class="image">
                                        <img src="<?php echo esc_url( $item['slide_img']['url'] );?>" alt="<?php esc_attr_e('Awesome Image', 'manzil'); ?>" />
                                    </div>
                                </div>
                                <?php endforeach;?>
                            </div>
                        </div>
                        <div class="lower-content">
                            <div class="title"><?php echo wp_kses( $settings['subtitle'], $allowed_tags );?></div>
                            <h2><?php echo wp_kses( $settings['title'], $allowed_tags );?></h2>
                            <div class="row clearfix">
                                <div class="column col-lg-8 col-md-12 col-sm-12">
                                    <?php echo wp_kses( $settings['text'], $allowed_tags );?>
                                    <?php echo wp_kses( $settings['text1'], $allowed_tags );?>
                                </div>
                                <div class="column col-lg-4 col-md-12 col-sm-12">
                                    <div class="project-info-boxed">
                                        <ul>
                                            
											<?php foreach($settings['project_info'] as $key => $item):?>
                                            <li><span><?php echo wp_kses($item['project_info_title'], $allowed_tags);?></span><?php echo wp_kses($item['project_info_text'], $allowed_tags);?></li>
                                            <?php endforeach;?>
                                            
                                            <li><span><?php esc_html_e('Share:', 'manzil'); ?></span>
                                                <?php foreach($settings['social_info'] as $key => $item):?>
                                                <a href="<?php echo esc_url($item['social_link']['url']);?>" class="fa <?php echo esc_attr($item['social_icon']);?>"></a>
                                                <?php endforeach;?>
                                            </li>
                                            
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <h3><?php echo wp_kses( $settings['sub_heading'], $allowed_tags );?></h3>
                            <p><?php echo wp_kses( $settings['text2'], $allowed_tags );?></p>
                            <div class="row clearfix">
                                <div class="column col-lg-5 col-md-12 col-sm-12">
                                    <h3><?php echo wp_kses( $settings['sub_heading2'], $allowed_tags );?></h3>
                                    <p><?php echo wp_kses( $settings['text3'], $allowed_tags );?></p>
                                    <h3><?php echo wp_kses( $settings['sub_heading3'], $allowed_tags );?></h3>
                                    <p><?php echo wp_kses( $settings['text4'], $allowed_tags );?></p>
                                </div>
                                <div class="column col-lg-7 col-md-12 col-sm-12">
                                    <div class="chart-image">
                                        <img src="<?php echo esc_url( $settings['chart_img']['url'] );?>" alt="<?php esc_attr_e('Awesome Image', 'manzil'); ?>" />
                                    </div>
                                </div>
                            </div>
                            <p><?php echo wp_kses( $settings['text5'], $allowed_tags );?></p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Gallery Detail Section -->
        
		<?php endif;
	}

}
