<?php

namespace MANZILPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Team extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'manzil_our_team';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Team', 'manzil' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'manzil' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'our_team',
			[
				'label' => esc_html__( 'Our Team', 'manzil' ),
			]
		);
		$this->add_control(
			'bg_img',
				[
				  'label' => __( 'Background Image', 'manzil' ),
				  'type' => Controls_Manager::MEDIA,
				  'default' => ['url' => Utils::get_placeholder_image_src(),],
				  
				]
	    );
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub title', 'manzil' ),
				'default'     => __( 'Team Members', 'manzil' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
				'default'     => __( '', 'manzil' ),
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'manzil' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'manzil' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'manzil' ),
					'title'      => esc_html__( 'Title', 'manzil' ),
					'menu_order' => esc_html__( 'Menu Order', 'manzil' ),
					'rand'       => esc_html__( 'Random', 'manzil' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'manzil' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESc' => esc_html__( 'DESC', 'manzil' ),
					'ASC'  => esc_html__( 'ASC', 'manzil' ),
				),
			]
		);
		$this->add_control(
			'query_exclude',
			[
				'label'       => esc_html__( 'Exclude', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'Exclude posts, pages, etc. by ID with comma separated.', 'manzil' ),
			]
		);
		$this->add_control(
            'query_category', 
				[
				  'type' => Controls_Manager::SELECT,
				  'label' => esc_html__('Category', 'manzil'),
				  'options' => get_team_categories()
				]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = manzil_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;

		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-manzil' );
		$args = array(
			'post_type'      => 'manzil_team',
			'posts_per_page' => manzil_set( $settings, 'query_number' ),
			'orderby'        => manzil_set( $settings, 'query_orderby' ),
			'order'          => manzil_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		if ( manzil_set( $settings, 'query_exclude' ) ) {
			$settings['query_exclude'] = explode( ',', $settings['query_exclude'] );
			$args['post__not_in']      = manzil_set( $settings, 'query_exclude' );
		}
		
		if( manzil_set( $settings, 'query_category' ) ) $args['team_cat'] = manzil_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );

		if ( $query->have_posts() ) 
		{ ?>
		
        <!-- Team Section -->
        <section class="team-section">
            <div class="image-layer" style="background-image:url(<?php echo esc_url($settings['bg_img']['url']);?>)"></div>
            <div class="auto-container">
                <!-- Sec Title -->
                <div class="sec-title light centered">
                    <div class="title">
                        <!-- Title Effect -->
                        <div class="title-effect">
                            <div class="bar bar-top"></div>
                            <div class="bar bar-right"></div>
                            <div class="bar bar-bottom"></div>
                            <div class="bar bar-left"></div>
                        </div>
                        <?php echo wp_kses($settings['subtitle'], $allowed_tags);?>
                    </div>
                    <h2><?php echo wp_kses($settings['title'], $allowed_tags);?></h2>
                </div>
                <div class="three-item-carousel owl-carousel owl-theme">
                    <?php while ( $query->have_posts() ) : $query->the_post(); ?>
                    <!-- Team Block -->
                    <div class="team-block">
                        <div class="inner-box">
                            <div class="image">
                                <?php the_post_thumbnail('manzil_350x470'); ?>
                                <?php
									$icons = get_post_meta( get_the_id(), 'social_profile', true );
									if ( ! empty( $icons ) ) :
								?>
                                <!-- Social Box -->
                                <ul class="social-box">
                                    <?php
									foreach ( $icons as $h_icon ) :
									$header_social_icons = json_decode( urldecode( manzil_set( $h_icon, 'data' ) ) );
									if ( manzil_set( $header_social_icons, 'enable' ) == '' ) {
										continue;
									}
									$icon_class = explode( '-', manzil_set( $header_social_icons, 'icon' ) );
									?>
									<li><a href="<?php echo manzil_set( $header_social_icons, 'url' ); ?>" style="background-color:<?php echo manzil_set( $header_social_icons, 'background' ); ?>; color: <?php echo manzil_set( $header_social_icons, 'color' ); ?>" class="fa <?php echo esc_attr( manzil_set( $header_social_icons, 'icon' ) ); ?>"></a></li>
									<?php endforeach; ?>
                                </ul>
                                <?php endif; ?>
                            </div>
                            <div class="lower-content">
                                <h5><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'team_link', true));?>"><?php the_title(); ?></a></h5>
                                <div class="designation"><?php echo (get_post_meta( get_the_id(), 'designation', true ));?></div>
                                <!-- Arrows -->
                                <a href="<?php echo esc_url(get_post_meta( get_the_id(), 'team_link', true));?>" class="team-arrows-right">
                                    <div class="chevron"></div>
                                    <div class="chevron"></div>
                                    <div class="chevron"></div>
                                    <div class="chevron"></div>
                                </a>
                                
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </section>
        <!-- End Team Section -->
         
        <?php }
		wp_reset_postdata();
	}

}
