<?php

namespace MANZILPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Projects_V3 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'manzil_our_projects_v3';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Projects V3', 'manzil' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'manzil' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'our_projects_v3',
			[
				'label' => esc_html__( 'Our Projects V3', 'manzil' ),
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub title', 'manzil' ),
				'default'     => __( 'Projects', 'manzil' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'manzil' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'manzil' ),
			]
		);
		$this->add_control(
			'number',
			[
				'label'   => esc_html__( 'Number of post', 'manzil' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'cat_exclude',
			[
				'label'       => esc_html__( 'Exclude', 'manzil' ),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'Exclude categories, etc. by ID with comma separated.', 'manzil' ),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'manzil' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESc' => esc_html__( 'DESC', 'manzil' ),
					'ASC'  => esc_html__( 'ASC', 'manzil' ),
				),
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'manzil' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'manzil' ),
					'title'      => esc_html__( 'Title', 'manzil' ),
					'menu_order' => esc_html__( 'Menu Order', 'manzil' ),
					'rand'       => esc_html__( 'Random', 'manzil' ),
				),
			]
		);
		$this->end_controls_section();
		
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		
		$paged = get_query_var('paged');
		$paged = manzil_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;
		
		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-fixkar' );
		$args = array(
			'post_type'      => 'manzil_project',
			'posts_per_page' => manzil_set( $settings, 'number' ),
			'orderby'        => manzil_set( $settings, 'query_orderby' ),
			'order'          => manzil_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		$terms_array = explode(",",manzil_set( $settings, 'cat_exclude' ));
		if(manzil_set( $settings, 'cat_exclude' )) $args['tax_query'] = array(array('taxonomy' => 'project_cat','field' => 'id','terms' => $terms_array,'operator' => 'NOT IN',));
		$allowed_tags = wp_kses_allowed_html('post');
		$query = new \WP_Query( $args );
		$t = '';
		$data_filtration = '';
		$data_posts = '';
		if ( $query->have_posts() ) 
		{
		ob_start();
		?>
  
		<?php 
            $count = 0; 
            $fliteration = array();
            while( $query->have_posts() ): $query->the_post();
            global  $post;
            $meta = ''; //printr($meta);
            $meta1 = ''; //_WSH()->get_meta();
            $post_terms = get_the_terms( get_the_id(), 'project_cat');// printr($post_terms); exit();
            foreach( (array)$post_terms as $pos_term ) $fliteration[$pos_term->term_id] = $pos_term;
            $temp_category = get_the_term_list(get_the_id(), 'project_cat', '', ', ');
            
            $post_terms = wp_get_post_terms( get_the_id(), 'project_cat'); 
            $term_slug = '';
            if( $post_terms ) foreach( $post_terms as $p_term ) $term_slug .= $p_term->slug.' ';
        	
			$term_list = wp_get_post_terms(get_the_id(), 'project_cat', array("fields" => "names"));
			
			$post_thumbnail_id = get_post_thumbnail_id($post->ID);
            $post_thumbnail_url = wp_get_attachment_url($post_thumbnail_id);
            
			?>
            
            <!-- Gallery Block -->
            <div class="gallery-block mix all <?php echo esc_attr($term_slug); ?> col-lg-4 col-md-6 col-sm-12">
                <div class="inner-box">
                    <figure class="image-box">
                        <?php the_post_thumbnail('manzil_370x370'); ?>
                        <!-- Overlay Box -->
                        <div class="overlay-box">
                            <div class="overlay-inner">
                                <div class="content">
                                    <h6><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'ext_url', true ));?>"><?php the_title(); ?></a></h6>
                                    <div class="category"><?php echo implode( ', ', (array)$term_list );?></div>
                                </div>
                            </div>
                        </div>
                        <a href="<?php echo esc_url($post_thumbnail_url); ?>" data-fancybox="gallery-1" data-caption="" class="link"><span class="icon flaticon-full-screen"></span></a>
                    </figure>
                </div>
            </div>
            
            <?php endwhile;?>

            <?php wp_reset_postdata();
            $data_posts = ob_get_contents();
            ob_end_clean();
            
            ob_start();?>
            
            <?php $terms = get_terms(array('project_cat')); ?>
            
            <!-- Gallery Section -->
            <section class="gallery-section">
                <div class="auto-container">
                    <!-- Sec Title -->
                    <div class="sec-title centered">
                        <div class="title">
                            <!-- Title Effect -->
                            <div class="title-effect">
                                <div class="bar bar-top"></div>
                                <div class="bar bar-right"></div>
                                <div class="bar bar-bottom"></div>
                                <div class="bar bar-left"></div>
                            </div>
                            <?php echo wp_kses( $settings['subtitle'], $allowed_tags );?>
                        </div>
                        <h2><?php echo wp_kses( $settings['title'], $allowed_tags );?></h2>
                    </div>
                    <!--MixitUp Galery-->
                    <div class="mixitup-gallery">
                        
                        <!--Filter-->
                        <div class="filters clearfix">
                            
                            <ul class="filter-tabs filter-btns text-center clearfix">
                                <li class="active filter" data-role="button" data-filter="all"><?php esc_attr_e('All Cases', 'manzil');?></li>
                                <?php foreach( $fliteration as $t ): ?>
                                <li class="filter" data-role="button" data-filter=".<?php echo esc_attr(manzil_set( $t, 'slug' )); ?>"><?php echo manzil_set( $t, 'name'); ?></li>
                                <?php endforeach;?>
                            </ul>
                            
                        </div>
                        
                        <div class="filter-list row clearfix">
                            <?php echo wp_kses($data_posts, $allowed_tags); ?>
                        </div>
                        
                    </div>
                    
                    <!--Styled Pagination-->
                    <div class="styled-pagination text-center">
                        <?php manzil_the_pagination2(array('total'=>$query->max_num_pages, 'next_text' => 'Next <i class="fa fa-angle-double-right"></i> ', 'prev_text' => '<i class="fa fa-angle-double-left"></i> Prev')); ?>
                    </div>                
                    <!--End Styled Pagination-->
                    
                </div>
                
            </section>
            <!-- End Gallery Section -->
            
    	<?php }
	}

}
