<?php

namespace MANZILPLUGIN\Element;


class Elementor {
	static $widgets = array(
		//Home Page
		'about_us',
		'our_services',
		'call_to_action',
		'our_skills',
		'our_testimonials',
		'our_projects',
		'our_team',
		'latest_news',
		//Home Page Two
		'feature_services',
		'why_choose_us',
		'funfacts_and_video',
		'our_services_v2',
		'request_a_quote',
		'our_projects_v2',
		'pricing_plan',
		'latest_news_v2',
		'our_clients',
		//Home Page Three
		'our_services_v3',
		'about_us_v2',
		'funfacts_v2',
		'testimonials_faqs',
		'request_a_quote_v2',
		'how_we_work',
		'our_team_v2',
		'latest_news_v3',
		'our_clients_v2',
		//Inner Pages
		'our_faqs',
		'our_team_v3',
		'team_details',
		'our_testimonials_v2',
		'comming_soon',
		'terms_and_condition',
		'our_services_v4',
		'service_details',
		'our_projects_v3',
		'our_projects_v4',
		'related_project',
		'project_details',
		'blog_grid_view',
		'blog_with_sidebar',
		'google_map',
		'contact_info',
		'contact_us_v1',
		'contact_us_v2',
	);

	static function init() {
		add_action( 'elementor/init', array( __CLASS__, 'loader' ) );
		add_action( 'elementor/elements/categories_registered', array( __CLASS__, 'register_cats' ) );
	}

	static function loader() {

		foreach ( self::$widgets as $widget ) {

			$file = MANZILPLUGIN_PLUGIN_PATH . '/elementor/' . $widget . '.php';
			if ( file_exists( $file ) ) {
				require_once $file;
			}

			add_action( 'elementor/widgets/widgets_registered', array( __CLASS__, 'register' ) );
		}
	}

	static function register( $elemntor ) {
		foreach ( self::$widgets as $widget ) {
			$class = '\\MANZILPLUGIN\\Element\\' . ucwords( $widget );

			if ( class_exists( $class ) ) {
				$elemntor->register_widget_type( new $class );
			}
		}
	}

	static function register_cats( $elements_manager ) {

		$elements_manager->add_category(
			'manzil',
			[
				'title' => esc_html__( 'Manzil', 'manzil' ),
				'icon'  => 'fa fa-plug',
			]
		);
		$elements_manager->add_category(
			'templatepath',
			[
				'title' => esc_html__( 'Yogs Themes', 'manzil' ),
				'icon'  => 'fa fa-plug',
			]
		);

	}
}

Elementor::init();