<?php

namespace MANZILPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Contact_Info extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'manzil_contact_info';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Contact Info', 'manzil' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'manzil' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'contact_info',
			[
				'label' => esc_html__( 'Contact Info', 'manzil' ),
			]
		);
		$this->add_control(
              'info', 
			  	[
            		'type' => Controls_Manager::REPEATER,
            		'seperator' => 'before',
            		'default' => 
						[
                			['block_title' => esc_html__('Mail us for information', 'manzil')],
                			['block_title' => esc_html__('Working hours', 'manzil')],
                			['block_title' => esc_html__('Call for help', 'manzil')],
							['block_title' => esc_html__('Address:', 'manzil')]
            			],
            		'fields' => 
						[
                			[
							  'name' => 'icons_image',
							  'label' => __( 'Icon Image', 'manzil' ),
							  'type' => Controls_Manager::MEDIA,
							  'default' => ['url' => Utils::get_placeholder_image_src(),],
							],
							[
                    			'name' => 'block_title',
                    			'label' => esc_html__('Title', 'manzil'),
                    			'type' => Controls_Manager::TEXT,
                    			'default' => esc_html__('', 'manzil')
                			],
							[
                    			'name' => 'block_description',
                    			'label' => esc_html__('Description', 'manzil'),
                    			'type' => Controls_Manager::TEXTAREA,
                    			'default' => esc_html__('Enter Description', 'manzil')
                			],
            			],
            	    'title_field' => '{{block_title}}',
                 ]
        );
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>
        
        <!-- Contact Info Section -->
        <section class="contact-info-section">
            <div class="auto-container">
                <div class="row clearfix">
                    <?php foreach($settings['info'] as $item):?>
                    <!-- Info Box -->
                    <div class="info-box col-lg-3 col-md-6 col-sm-12">
                        <div class="inner-box">
                            <div class="icon"><img src="<?php echo esc_url($item['icons_image']['url']);?>" alt="<?php esc_attr_e('Awesome Image', 'manzil'); ?>" /></div>
                            <h5><?php echo wp_kses($item['block_title'], $allowed_tags);?></h5>
                            <?php echo wp_kses($item['block_description'], $allowed_tags);?>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>
        </section>
        <!-- End Contact Info Section -->
        
		<?php 
	}

}
